/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.http2.generator;

import io.opentelemetry.testing.internal.jetty.http.MetaData;
import io.opentelemetry.testing.internal.jetty.http2.frames.Frame;
import io.opentelemetry.testing.internal.jetty.http2.frames.FrameType;
import io.opentelemetry.testing.internal.jetty.http2.generator.HeaderGenerator;
import io.opentelemetry.testing.internal.jetty.http2.hpack.HpackEncoder;
import io.opentelemetry.testing.internal.jetty.http2.hpack.HpackException;
import io.opentelemetry.testing.internal.jetty.io.ByteBufferPool;
import java.nio.ByteBuffer;

public abstract class FrameGenerator {
    private final HeaderGenerator headerGenerator;

    protected FrameGenerator(HeaderGenerator headerGenerator) {
        this.headerGenerator = headerGenerator;
    }

    public abstract int generate(ByteBufferPool.Lease var1, Frame var2) throws HpackException;

    protected ByteBuffer generateHeader(ByteBufferPool.Lease lease, FrameType frameType, int length, int flags, int streamId) {
        return this.headerGenerator.generate(lease, frameType, 9 + length, length, flags, streamId);
    }

    public int getMaxFrameSize() {
        return this.headerGenerator.getMaxFrameSize();
    }

    protected ByteBuffer encode(HpackEncoder encoder, ByteBufferPool.Lease lease, MetaData metaData, int maxFrameSize) throws HpackException {
        ByteBuffer hpacked = lease.acquire(maxFrameSize, false);
        try {
            encoder.encode(hpacked, metaData);
            return hpacked;
        }
        catch (HpackException x) {
            lease.release(hpacked);
            throw x;
        }
    }
}

