/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.http2.frames;

import io.opentelemetry.testing.internal.jetty.http.MetaData;
import io.opentelemetry.testing.internal.jetty.http2.frames.FrameType;
import io.opentelemetry.testing.internal.jetty.http2.frames.StreamFrame;

public class PushPromiseFrame
extends StreamFrame {
    private final int promisedStreamId;
    private final MetaData metaData;

    public PushPromiseFrame(int streamId, MetaData metaData) {
        this(streamId, 0, metaData);
    }

    public PushPromiseFrame(int streamId, int promisedStreamId, MetaData metaData) {
        super(FrameType.PUSH_PROMISE, streamId);
        this.promisedStreamId = promisedStreamId;
        this.metaData = metaData;
    }

    public int getPromisedStreamId() {
        return this.promisedStreamId;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public PushPromiseFrame withStreamId(int streamId) {
        return new PushPromiseFrame(this.getStreamId(), streamId, this.getMetaData());
    }

    @Override
    public String toString() {
        return String.format("%s#%d/#%d", super.toString(), this.getStreamId(), this.promisedStreamId);
    }
}

