/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.client.http;

import io.opentelemetry.testing.internal.jetty.client.AbstractConnectorHttpClientTransport;
import io.opentelemetry.testing.internal.jetty.client.DuplexConnectionPool;
import io.opentelemetry.testing.internal.jetty.client.HttpDestination;
import io.opentelemetry.testing.internal.jetty.client.Origin;
import io.opentelemetry.testing.internal.jetty.client.api.Connection;
import io.opentelemetry.testing.internal.jetty.client.http.HttpConnectionOverHTTP;
import io.opentelemetry.testing.internal.jetty.client.http.HttpDestinationOverHTTP;
import io.opentelemetry.testing.internal.jetty.io.EndPoint;
import io.opentelemetry.testing.internal.jetty.util.Callback;
import io.opentelemetry.testing.internal.jetty.util.ProcessorUtils;
import io.opentelemetry.testing.internal.jetty.util.Promise;
import io.opentelemetry.testing.internal.jetty.util.annotation.ManagedAttribute;
import io.opentelemetry.testing.internal.jetty.util.annotation.ManagedObject;
import java.io.IOException;
import java.util.Map;

@ManagedObject(value="The HTTP/1.1 client transport")
public class HttpClientTransportOverHTTP
extends AbstractConnectorHttpClientTransport {
    private int headerCacheSize = 1024;

    public HttpClientTransportOverHTTP() {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int selectors) {
        super(selectors);
        this.setConnectionPoolFactory(destination -> new DuplexConnectionPool(destination, this.getHttpClient().getMaxConnectionsPerDestination(), (Callback)destination));
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP(this.getHttpClient(), origin);
    }

    @Override
    public io.opentelemetry.testing.internal.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        Promise promise = (Promise)context.get("http.connection.promise");
        HttpConnectionOverHTTP connection = this.newHttpConnection(endPoint, destination, promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", connection);
        }
        return this.customize(connection, context);
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<Connection> promise) {
        return new HttpConnectionOverHTTP(endPoint, destination, promise);
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for an HTTP header field cache")
    public int getHeaderCacheSize() {
        return this.headerCacheSize;
    }

    public void setHeaderCacheSize(int headerCacheSize) {
        this.headerCacheSize = headerCacheSize;
    }
}

