/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jetty.alpn.java.server;

import io.opentelemetry.testing.internal.jetty.alpn.server.ALPNServerConnection;
import io.opentelemetry.testing.internal.jetty.io.Connection;
import io.opentelemetry.testing.internal.jetty.io.ssl.ALPNProcessor;
import io.opentelemetry.testing.internal.jetty.io.ssl.SslConnection;
import io.opentelemetry.testing.internal.jetty.io.ssl.SslHandshakeListener;
import io.opentelemetry.testing.internal.jetty.util.JavaVersion;
import io.opentelemetry.testing.internal.jetty.util.log.Log;
import io.opentelemetry.testing.internal.jetty.util.log.Logger;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;

public class JDK9ServerALPNProcessor
implements ALPNProcessor.Server,
SslHandshakeListener {
    private static final Logger LOG = Log.getLogger(JDK9ServerALPNProcessor.class);

    @Override
    public void init() {
        if (JavaVersion.VERSION.getPlatform() < 9) {
            throw new IllegalStateException(this + " not applicable for java " + JavaVersion.VERSION);
        }
    }

    @Override
    public boolean appliesTo(SSLEngine sslEngine) {
        Module module = sslEngine.getClass().getModule();
        return module != null && "java.base".equals(module.getName());
    }

    @Override
    public void configure(SSLEngine sslEngine, Connection connection) {
        sslEngine.setHandshakeApplicationProtocolSelector(new ALPNCallback((ALPNServerConnection)connection));
    }

    private static final class ALPNCallback
    implements BiFunction<SSLEngine, List<String>, String>,
    SslHandshakeListener {
        private final ALPNServerConnection alpnConnection;

        private ALPNCallback(ALPNServerConnection connection) {
            this.alpnConnection = connection;
            ((SslConnection.DecryptedEndPoint)this.alpnConnection.getEndPoint()).getSslConnection().addHandshakeListener(this);
        }

        @Override
        public String apply(SSLEngine engine, List<String> protocols) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("apply {} {}", this.alpnConnection, protocols);
                }
                this.alpnConnection.select(protocols);
                return this.alpnConnection.getProtocol();
            }
            catch (Throwable x) {
                return null;
            }
        }

        @Override
        public void handshakeSucceeded(SslHandshakeListener.Event event) {
            String protocol = this.alpnConnection.getProtocol();
            if (LOG.isDebugEnabled()) {
                LOG.debug("TLS handshake succeeded, protocol={} for {}", protocol, this.alpnConnection);
            }
            if (protocol == null) {
                this.alpnConnection.unsupported();
            }
        }

        @Override
        public void handshakeFailed(SslHandshakeListener.Event event, Throwable failure) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("TLS handshake failed " + this.alpnConnection, failure);
            }
        }
    }
}

