/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.brotli4j.decoder;

import io.opentelemetry.testing.internal.brotli4j.decoder.Decoder;
import io.opentelemetry.testing.internal.brotli4j.decoder.DecoderJNI;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufUtil;
import io.opentelemetry.testing.internal.io.netty.buffer.Unpooled;
import java.io.IOException;

public final class DirectDecompress {
    private final DecoderJNI.Status resultStatus;
    private byte[] decompressedData;
    private ByteBuf byteBuf;

    DirectDecompress(DecoderJNI.Status resultStatus, byte[] decompressedData, ByteBuf byteBuf) {
        this.resultStatus = resultStatus;
        this.decompressedData = decompressedData;
        this.byteBuf = byteBuf;
    }

    public static DirectDecompress decompress(byte[] compressedData) throws IOException {
        return Decoder.decompress(compressedData);
    }

    public DecoderJNI.Status getResultStatus() {
        return this.resultStatus;
    }

    public byte[] getDecompressedData() {
        if (this.decompressedData == null && this.byteBuf != null) {
            this.decompressedData = ByteBufUtil.getBytes(this.byteBuf);
        }
        return this.decompressedData;
    }

    public ByteBuf getDecompressedDataByteBuf() {
        if (this.byteBuf == null && this.decompressedData != null) {
            this.byteBuf = Unpooled.wrappedBuffer(this.decompressedData);
        }
        return this.byteBuf;
    }
}

