/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.brotli4j.common;

import io.opentelemetry.testing.internal.brotli4j.common.CommonJNI;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class BrotliCommon {
    public static final int RFC_DICTIONARY_SIZE = 122784;
    private static final byte[] RFC_DICTIONARY_MD5 = new byte[]{-106, -50, -51, 46, -25, -90, 102, -43, -86, 54, 39, -41, 71, 53, -77, 42};
    private static final byte[] RFC_DICTIONARY_SHA_1 = new byte[]{114, -76, 16, 81, -53, 97, -87, 40, 27, -93, -60, 65, 76, 40, -99, -91, 13, -102, 118, 64};
    private static final byte[] RFC_DICTIONARY_SHA_256 = new byte[]{32, -28, 46, -79, -75, 17, -62, 24, 6, -44, -46, 39, -48, 126, 93, -48, 104, 119, -40, -50, 123, 58, -127, 127, 55, -113, 49, 54, 83, -13, 92, 112};
    private static boolean isDictionaryDataSet;
    private static final Object mutex;

    public static boolean checkDictionaryDataMd5(byte[] digest) {
        return Arrays.equals(RFC_DICTIONARY_MD5, digest);
    }

    public static boolean checkDictionaryDataSha1(byte[] digest) {
        return Arrays.equals(RFC_DICTIONARY_SHA_1, digest);
    }

    public static boolean checkDictionaryDataSha256(byte[] digest) {
        return Arrays.equals(RFC_DICTIONARY_SHA_256, digest);
    }

    public static ByteBuffer makeNative(byte[] data) {
        ByteBuffer result = ByteBuffer.allocateDirect(data.length);
        result.put(data);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDictionaryData(byte[] data) {
        if (data.length != 122784) {
            throw new IllegalArgumentException("invalid dictionary size");
        }
        Object object = mutex;
        synchronized (object) {
            if (isDictionaryDataSet) {
                return;
            }
            BrotliCommon.setDictionaryData(BrotliCommon.makeNative(data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDictionaryData(InputStream src) throws IOException {
        Object object = mutex;
        synchronized (object) {
            int readBytes;
            if (isDictionaryDataSet) {
                return;
            }
            ByteBuffer copy = ByteBuffer.allocateDirect(122784);
            byte[] buffer = new byte[4096];
            while ((readBytes = src.read(buffer)) != -1) {
                if (copy.remaining() < readBytes) {
                    throw new IllegalArgumentException("invalid dictionary size");
                }
                copy.put(buffer, 0, readBytes);
            }
            if (copy.remaining() != 0) {
                throw new IllegalArgumentException("invalid dictionary size " + copy.remaining());
            }
            BrotliCommon.setDictionaryData(copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDictionaryData(ByteBuffer data) {
        if (!data.isDirect()) {
            throw new IllegalArgumentException("direct byte buffer is expected");
        }
        if (data.capacity() != 122784) {
            throw new IllegalArgumentException("invalid dictionary size");
        }
        Object object = mutex;
        synchronized (object) {
            if (isDictionaryDataSet) {
                return;
            }
            if (!CommonJNI.nativeSetDictionaryData(data)) {
                throw new RuntimeException("setting dictionary failed");
            }
            isDictionaryDataSet = true;
        }
    }

    static {
        mutex = new Object();
    }
}

