/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.throttling;

import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.throttling.RateLimitingThrottlingStrategy;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;

public abstract class ThrottlingStrategy<T extends Request> {
    private static final AtomicInteger GLOBAL_STRATEGY_ID = new AtomicInteger();
    private static final ThrottlingStrategy<?> NEVER = new ThrottlingStrategy<Request>("throttling-strategy-never"){

        @Override
        public CompletionStage<Boolean> accept(ServiceRequestContext ctx, Request request) {
            return UnmodifiableFuture.completedFuture(false);
        }
    };
    private static final ThrottlingStrategy<?> ALWAYS = new ThrottlingStrategy<Request>("throttling-strategy-always"){

        @Override
        public CompletionStage<Boolean> accept(ServiceRequestContext ctx, Request request) {
            return UnmodifiableFuture.completedFuture(true);
        }
    };
    private final String name;

    public static <T extends Request> ThrottlingStrategy<T> never() {
        return NEVER;
    }

    public static <T extends Request> ThrottlingStrategy<T> always() {
        return ALWAYS;
    }

    public static <T extends Request> ThrottlingStrategy<T> of(final BiFunction<? super ServiceRequestContext, T, ? extends CompletionStage<Boolean>> function, String strategyName) {
        return new ThrottlingStrategy<T>(strategyName){

            @Override
            public CompletionStage<Boolean> accept(ServiceRequestContext ctx, T request) {
                return (CompletionStage)function.apply(ctx, request);
            }
        };
    }

    public static <T extends Request> ThrottlingStrategy<T> of(final BiFunction<? super ServiceRequestContext, T, ? extends CompletionStage<Boolean>> function) {
        return new ThrottlingStrategy<T>(null){

            @Override
            public CompletionStage<Boolean> accept(ServiceRequestContext ctx, T request) {
                return (CompletionStage)function.apply(ctx, request);
            }
        };
    }

    public static <T extends Request> ThrottlingStrategy<T> rateLimiting(double requestsPerSecond) {
        return new RateLimitingThrottlingStrategy(requestsPerSecond);
    }

    public static <T extends Request> ThrottlingStrategy<T> rateLimiting(double requestsPerSecond, String name) {
        return new RateLimitingThrottlingStrategy(requestsPerSecond, name);
    }

    protected ThrottlingStrategy() {
        this(null);
    }

    protected ThrottlingStrategy(@Nullable String name) {
        this.name = name != null ? name : "throttling-strategy-" + (this.getClass().isAnonymousClass() ? Integer.toString(GLOBAL_STRATEGY_ID.getAndIncrement()) : this.getClass().getSimpleName());
    }

    public abstract CompletionStage<Boolean> accept(ServiceRequestContext var1, T var2);

    public final String name() {
        return this.name;
    }
}

