/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.logging;

import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.ContentPreviewerFactory;
import io.opentelemetry.testing.internal.armeria.common.util.Functions;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.logging.ContentPreviewingService;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class ContentPreviewingServiceBuilder {
    private static final BiFunction<? super RequestContext, String, ? extends @Nullable Object> DEFAULT_REQUEST_PREVIEW_SANITIZER = Functions.second();
    private static final BiFunction<? super RequestContext, String, ? extends @Nullable Object> DEFAULT_RESPONSE_PREVIEW_SANITIZER = Functions.second();
    private final ContentPreviewerFactory contentPreviewerFactory;
    private BiFunction<? super RequestContext, String, ? extends @Nullable Object> requestPreviewSanitizer = DEFAULT_REQUEST_PREVIEW_SANITIZER;
    private BiFunction<? super RequestContext, String, ? extends @Nullable Object> responsePreviewSanitizer = DEFAULT_RESPONSE_PREVIEW_SANITIZER;

    ContentPreviewingServiceBuilder(ContentPreviewerFactory contentPreviewerFactory) {
        this.contentPreviewerFactory = contentPreviewerFactory;
    }

    public ContentPreviewingServiceBuilder requestPreviewSanitizer(BiFunction<? super RequestContext, String, ? extends @Nullable Object> requestPreviewSanitizer) {
        this.requestPreviewSanitizer = Objects.requireNonNull(requestPreviewSanitizer, "requestPreviewSanitizer");
        return this;
    }

    public ContentPreviewingServiceBuilder responsePreviewSanitizer(BiFunction<? super RequestContext, String, ? extends @Nullable Object> responsePreviewSanitizer) {
        this.responsePreviewSanitizer = Objects.requireNonNull(responsePreviewSanitizer, "responsePreviewSanitizer");
        return this;
    }

    public ContentPreviewingServiceBuilder previewSanitizer(BiFunction<? super RequestContext, String, ? extends @Nullable Object> previewSanitizer) {
        Objects.requireNonNull(previewSanitizer, "previewSanitizer");
        this.requestPreviewSanitizer = previewSanitizer;
        this.responsePreviewSanitizer = previewSanitizer;
        return this;
    }

    public ContentPreviewingService build(HttpService delegate) {
        return new ContentPreviewingService(delegate, this.contentPreviewerFactory, this.requestPreviewSanitizer, this.responsePreviewSanitizer);
    }

    public Function<? super HttpService, ContentPreviewingService> newDecorator() {
        return this::build;
    }
}

