/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.file;

import io.opentelemetry.testing.internal.armeria.common.CacheControl;
import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.server.file.FileService;
import io.opentelemetry.testing.internal.armeria.server.file.FileServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.file.HttpVfs;
import io.opentelemetry.testing.internal.armeria.server.file.MediaTypeResolver;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class FileServiceBuilder {
    @Nullable
    private static final String DEFAULT_ENTRY_CACHE_SPEC = Flags.fileServiceCacheSpec();
    private static final int DEFAULT_MAX_CACHE_ENTRY_SIZE_BYTES = 65536;
    final HttpVfs vfs;
    Clock clock = Clock.systemUTC();
    @Nullable
    String entryCacheSpec = DEFAULT_ENTRY_CACHE_SPEC;
    int maxCacheEntrySizeBytes = 65536;
    boolean serveCompressedFiles;
    private boolean autoDecompress;
    boolean autoIndex;
    boolean canSetMaxCacheEntries = true;
    boolean canSetEntryCacheSpec = true;
    @Nullable
    HttpHeadersBuilder headers;
    MediaTypeResolver mediaTypeResolver = MediaTypeResolver.ofDefault();
    @Nullable
    private ImmutableList.Builder<String> fallbackFileExtensions;

    FileServiceBuilder(HttpVfs vfs) {
        this.vfs = Objects.requireNonNull(vfs, "vfs");
    }

    public FileServiceBuilder clock(Clock clock) {
        this.clock = Objects.requireNonNull(clock, "clock");
        return this;
    }

    public FileServiceBuilder maxCacheEntries(int maxCacheEntries) {
        Preconditions.checkState(this.canSetMaxCacheEntries, "Cannot call maxCacheEntries() if called entryCacheSpec() already.");
        FileServiceConfig.validateNonNegativeParameter(maxCacheEntries, "maxCacheEntries");
        this.entryCacheSpec = maxCacheEntries == 0 ? null : String.format("maximumSize=%d", maxCacheEntries);
        this.canSetEntryCacheSpec = false;
        return this;
    }

    public FileServiceBuilder entryCacheSpec(String entryCacheSpec) {
        Objects.requireNonNull(entryCacheSpec, "entryCacheSpec");
        Preconditions.checkState(this.canSetEntryCacheSpec, "Cannot call entryCacheSpec() if called maxCacheEntries() already.");
        this.entryCacheSpec = FileServiceConfig.validateEntryCacheSpec(entryCacheSpec);
        this.canSetMaxCacheEntries = false;
        return this;
    }

    public FileServiceBuilder serveCompressedFiles(boolean serveCompressedFiles) {
        this.serveCompressedFiles = serveCompressedFiles;
        return this;
    }

    public FileServiceBuilder autoDecompress(boolean autoDecompress) {
        this.autoDecompress = autoDecompress;
        return this;
    }

    public FileServiceBuilder maxCacheEntrySizeBytes(int maxCacheEntrySizeBytes) {
        this.maxCacheEntrySizeBytes = FileServiceConfig.validateMaxCacheEntrySizeBytes(maxCacheEntrySizeBytes);
        return this;
    }

    public FileServiceBuilder autoIndex(boolean autoIndex) {
        this.autoIndex = autoIndex;
        return this;
    }

    @UnstableApi
    public FileServiceBuilder fallbackFileExtensions(String ... extensions) {
        Objects.requireNonNull(extensions, "extensions");
        return this.fallbackFileExtensions(ImmutableList.copyOf(extensions));
    }

    @UnstableApi
    public FileServiceBuilder fallbackFileExtensions(Iterable<String> extensions) {
        Objects.requireNonNull(extensions, "extensions");
        for (String extension : extensions) {
            Preconditions.checkArgument(!extension.isEmpty(), "extension is empty");
            Preconditions.checkArgument(extension.charAt(0) != '.', "extension: %s (expected: without a dot)", (Object)extension);
        }
        if (this.fallbackFileExtensions == null) {
            this.fallbackFileExtensions = ImmutableList.builder();
        }
        this.fallbackFileExtensions.addAll((Iterable)extensions);
        return this;
    }

    private List<String> fallbackFileExtensions() {
        return this.fallbackFileExtensions != null ? this.fallbackFileExtensions.build() : ImmutableList.of();
    }

    HttpHeaders buildHeaders() {
        return this.headers != null ? this.headers.build() : HttpHeaders.of();
    }

    private HttpHeadersBuilder headersBuilder() {
        if (this.headers == null) {
            this.headers = HttpHeaders.builder();
        }
        return this.headers;
    }

    public FileServiceBuilder addHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.headersBuilder().addObject((CharSequence)HttpHeaderNames.of(name), value);
        return this;
    }

    public FileServiceBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        Objects.requireNonNull(headers, "headers");
        this.headersBuilder().addObject(headers);
        return this;
    }

    public FileServiceBuilder setHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.headersBuilder().setObject((CharSequence)HttpHeaderNames.of(name), value);
        return this;
    }

    public FileServiceBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        Objects.requireNonNull(headers, "headers");
        this.headersBuilder().setObject(headers);
        return this;
    }

    public FileServiceBuilder cacheControl(CacheControl cacheControl) {
        Objects.requireNonNull(cacheControl, "cacheControl");
        return this.setHeader(HttpHeaderNames.CACHE_CONTROL, cacheControl);
    }

    public FileServiceBuilder cacheControl(CharSequence cacheControl) {
        Objects.requireNonNull(cacheControl, "cacheControl");
        return this.setHeader(HttpHeaderNames.CACHE_CONTROL, cacheControl);
    }

    public FileServiceBuilder mediaTypeResolver(MediaTypeResolver mediaTypeResolver) {
        this.mediaTypeResolver = Objects.requireNonNull(mediaTypeResolver, "mediaTypeResolver");
        return this;
    }

    public FileService build() {
        if (this.autoDecompress && !this.serveCompressedFiles) {
            throw new IllegalStateException("Should enable serveCompressedFiles when autoDecompress is set");
        }
        return new FileService(new FileServiceConfig(this.vfs, this.clock, this.entryCacheSpec, this.maxCacheEntrySizeBytes, this.serveCompressedFiles, this.autoDecompress, this.autoIndex, this.buildHeaders(), this.mediaTypeResolver.orElse(MediaTypeResolver.ofDefault()), this.fallbackFileExtensions()));
    }

    public String toString() {
        return FileServiceConfig.toString(this, this.vfs, this.clock, this.entryCacheSpec, this.maxCacheEntrySizeBytes, this.serveCompressedFiles, this.autoIndex, this.headers, this.mediaTypeResolver, this.fallbackFileExtensions());
    }
}

