/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.file;

import io.opentelemetry.testing.internal.armeria.common.ContextAwareBlockingTaskExecutor;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.encoding.StreamDecoder;
import io.opentelemetry.testing.internal.armeria.common.encoding.StreamDecoderFactory;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.internal.common.HttpMessageAggregator;
import io.opentelemetry.testing.internal.armeria.internal.common.metric.CaffeineMetricSupport;
import io.opentelemetry.testing.internal.armeria.internal.common.util.TemporaryThreadLocals;
import io.opentelemetry.testing.internal.armeria.internal.shaded.caffeine.cache.Cache;
import io.opentelemetry.testing.internal.armeria.internal.shaded.caffeine.cache.Caffeine;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Splitter;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Sets;
import io.opentelemetry.testing.internal.armeria.server.AbstractHttpService;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.Route;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.file.AggregatedHttpFile;
import io.opentelemetry.testing.internal.armeria.server.file.AggregatedHttpFileBuilder;
import io.opentelemetry.testing.internal.armeria.server.file.AutoIndex;
import io.opentelemetry.testing.internal.armeria.server.file.DecompressingHttpFile;
import io.opentelemetry.testing.internal.armeria.server.file.FileServiceBuilder;
import io.opentelemetry.testing.internal.armeria.server.file.FileServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.file.HttpDataFile;
import io.opentelemetry.testing.internal.armeria.server.file.HttpFile;
import io.opentelemetry.testing.internal.armeria.server.file.HttpFileAttributes;
import io.opentelemetry.testing.internal.armeria.server.file.HttpFileBuilder;
import io.opentelemetry.testing.internal.armeria.server.file.HttpVfs;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufAllocator;
import io.opentelemetry.testing.internal.io.netty.handler.codec.compression.Brotli;
import java.io.File;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileService
extends AbstractHttpService {
    private static final Logger logger = LoggerFactory.getLogger(FileService.class);
    private static final Splitter COMMA_SPLITTER = Splitter.on(',');
    private static final UnmodifiableFuture<HttpFile> NON_EXISTENT_FILE_FUTURE = UnmodifiableFuture.completedFuture(HttpFile.nonExistent());
    private final FileServiceConfig config;
    @Nullable
    private final Cache<PathAndEncoding, AggregatedHttpFile> cache;

    public static FileService of(File rootDir) {
        return FileService.builder(rootDir).build();
    }

    public static FileService of(Path rootDir) {
        return FileService.builder(rootDir).build();
    }

    public static FileService of(ClassLoader classLoader, String rootDir) {
        return FileService.builder(classLoader, rootDir).build();
    }

    public static FileService of(HttpVfs vfs) {
        return FileService.builder(vfs).build();
    }

    public static FileServiceBuilder builder(File rootDir) {
        return FileService.builder(HttpVfs.of(rootDir));
    }

    public static FileServiceBuilder builder(Path rootDir) {
        return FileService.builder(HttpVfs.of(rootDir));
    }

    public static FileServiceBuilder builder(ClassLoader classLoader, String rootDir) {
        return FileService.builder(HttpVfs.of(classLoader, rootDir));
    }

    public static FileServiceBuilder builder(HttpVfs vfs) {
        return new FileServiceBuilder(vfs);
    }

    FileService(FileServiceConfig config) {
        this.config = Objects.requireNonNull(config, "config");
        String cacheSpec = config.entryCacheSpec();
        this.cache = cacheSpec != null ? FileService.newCache(cacheSpec) : null;
    }

    private static Cache<PathAndEncoding, AggregatedHttpFile> newCache(String cacheSpec) {
        Caffeine<Object, Object> b = Caffeine.from(cacheSpec);
        b.recordStats().removalListener((key, value, cause) -> {
            HttpData data;
            if (value != null && (data = value.content()) != null) {
                data.close();
            }
        });
        return b.build();
    }

    @Override
    public void serviceAdded(ServiceConfig cfg) throws Exception {
        MeterRegistry registry = cfg.server().meterRegistry();
        if (this.cache != null) {
            MeterIdPrefix meterIdPrefix = new MeterIdPrefix("armeria.server.file.vfs.cache", "hostname.pattern", cfg.virtualHost().hostnamePattern(), "route", cfg.route().patternString(), "vfs", this.config.vfs().meterTag());
            CaffeineMetricSupport.setup(registry, meterIdPrefix, this.cache);
        }
    }

    @Override
    public boolean shouldCachePath(String path, @Nullable String query, Route route) {
        return this.cache != null;
    }

    public FileServiceConfig config() {
        return this.config;
    }

    @Override
    protected HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return this.findFile(ctx, req).asService().serve(ctx, req);
    }

    private HttpFile findFile(ServiceRequestContext ctx, HttpRequest req) {
        EnumSet<ContentEncoding> encodings = EnumSet.noneOf(ContentEncoding.class);
        boolean needsDecompression = false;
        if (this.config.serveCompressedFiles()) {
            String acceptEncoding = req.headers().get(HttpHeaderNames.ACCEPT_ENCODING);
            if (acceptEncoding != null) {
                for (String encoding : COMMA_SPLITTER.split(acceptEncoding)) {
                    for (ContentEncoding possibleEncoding : ContentEncoding.values()) {
                        if (!encoding.contains(possibleEncoding.decoderFactory.encodingHeaderValue())) continue;
                        encodings.add(possibleEncoding);
                    }
                }
            }
            if (this.config().autoDecompress() && encodings.isEmpty()) {
                needsDecompression = true;
                encodings.addAll(ContentEncoding.availableEncodings);
            }
        }
        boolean decompress = needsDecompression;
        String decodedMappedPath = ctx.decodedMappedPath();
        return HttpFile.from(this.findFile(ctx, decodedMappedPath, encodings, decompress).thenCompose(file -> {
            boolean endsWithSlash;
            if (file != null) {
                return UnmodifiableFuture.completedFuture(file);
            }
            boolean bl = endsWithSlash = decodedMappedPath.charAt(decodedMappedPath.length() - 1) == '/';
            if (endsWithSlash) {
                String indexPath = decodedMappedPath + "index.html";
                return this.findFile(ctx, indexPath, encodings, decompress).thenCompose(indexFile -> {
                    if (indexFile != null) {
                        return UnmodifiableFuture.completedFuture(indexFile);
                    }
                    ContextAwareBlockingTaskExecutor readExecutor = ctx.blockingTaskExecutor();
                    if (!this.config.autoIndex()) {
                        return NON_EXISTENT_FILE_FUTURE;
                    }
                    return this.config.vfs().canList(readExecutor, decodedMappedPath).thenCompose(canList -> {
                        if (!canList.booleanValue()) {
                            return NON_EXISTENT_FILE_FUTURE;
                        }
                        return this.config.vfs().list(readExecutor, decodedMappedPath).thenApply(listing -> {
                            HttpData autoIndex = AutoIndex.listingToHtml(ctx.decodedPath(), decodedMappedPath, listing);
                            return ((HttpFileBuilder)HttpFile.builder(autoIndex).addHeader(HttpHeaderNames.CONTENT_TYPE, MediaType.HTML_UTF_8).setHeaders((Iterable)this.config.headers())).build();
                        });
                    });
                });
            }
            List<String> fallbackExtensions = this.config.fallbackFileExtensions();
            if (fallbackExtensions.isEmpty()) {
                return this.findFileWithIndexPath(ctx, decodedMappedPath, encodings, decompress);
            }
            return this.findFileWithExtensions(ctx, fallbackExtensions.iterator(), decodedMappedPath, encodings, decompress).thenCompose(fileWithExtension -> {
                if (fileWithExtension != null) {
                    return UnmodifiableFuture.completedFuture(fileWithExtension);
                }
                return this.findFileWithIndexPath(ctx, decodedMappedPath, encodings, decompress);
            });
        }));
    }

    private CompletableFuture<@Nullable HttpFile> findFile(ServiceRequestContext ctx, String path, Set<ContentEncoding> supportedEncodings, boolean decompress) {
        if (decompress) {
            return this.findFileAndDecompress(ctx, path, supportedEncodings);
        }
        return this.findFile(ctx, path, supportedEncodings.iterator(), false).thenCompose(file -> {
            if (file != null) {
                return UnmodifiableFuture.completedFuture(file);
            }
            return this.findFile(ctx, path, (ContentEncoding)null, false);
        });
    }

    private CompletableFuture<@Nullable HttpFile> findFile(ServiceRequestContext ctx, String path, Iterator<ContentEncoding> i, boolean decompress) {
        if (!i.hasNext()) {
            return UnmodifiableFuture.completedFuture(null);
        }
        ContentEncoding encoding = i.next();
        return this.findFile(ctx, path + encoding.extension, encoding, decompress).thenCompose(file -> {
            if (file != null) {
                return UnmodifiableFuture.completedFuture(file);
            }
            return this.findFile(ctx, path, i, decompress);
        });
    }

    private CompletableFuture<@Nullable HttpFile> findFile(ServiceRequestContext ctx, String path, @Nullable ContentEncoding encoding, boolean decompress) {
        ContextAwareBlockingTaskExecutor readExecutor = ctx.blockingTaskExecutor();
        String contentEncoding = encoding != null ? encoding.decoderFactory.encodingHeaderValue() : null;
        HttpFile uncachedFile = this.config.vfs().get(readExecutor, path, this.config.clock(), contentEncoding, this.config.headers(), this.config.mediaTypeResolver());
        return uncachedFile.readAttributes(readExecutor).thenApply(uncachedAttrs -> {
            if (this.cache == null) {
                if (uncachedAttrs != null) {
                    if (decompress && encoding != null) {
                        MediaType contentType = this.config.mediaTypeResolver().guessFromPath(path, contentEncoding);
                        return new DecompressingHttpFile(uncachedFile, encoding, contentType);
                    }
                    return uncachedFile;
                }
                return null;
            }
            PathAndEncoding pathAndEncoding = new PathAndEncoding(path, contentEncoding);
            if (uncachedAttrs == null) {
                this.cache.invalidate(pathAndEncoding);
                return null;
            }
            if (uncachedAttrs.length() > (long)this.config.maxCacheEntrySizeBytes()) {
                this.cache.invalidate(pathAndEncoding);
                return uncachedFile;
            }
            @Nullable AggregatedHttpFile cachedFile = this.cache.getIfPresent(pathAndEncoding);
            if (cachedFile == null) {
                return this.cache(ctx, pathAndEncoding, uncachedFile, encoding, decompress);
            }
            HttpFileAttributes cachedAttrs = cachedFile.attributes();
            assert (cachedAttrs != null);
            if (cachedAttrs.equals(uncachedAttrs)) {
                return cachedFile.toHttpFile();
            }
            this.cache.invalidate(pathAndEncoding);
            return this.cache(ctx, pathAndEncoding, uncachedFile, encoding, decompress);
        });
    }

    private CompletableFuture<@Nullable HttpFile> findFileWithIndexPath(ServiceRequestContext ctx, String decodedMappedPath, Set<ContentEncoding> encodings, boolean decompress) {
        String indexPath = decodedMappedPath + "/index.html";
        return ((CompletableFuture)this.findFile(ctx, indexPath, encodings, decompress).thenCompose(indexFile -> {
            if (indexFile != null) {
                return UnmodifiableFuture.completedFuture(true);
            }
            if (!this.config.autoIndex()) {
                return UnmodifiableFuture.completedFuture(false);
            }
            return this.config.vfs().canList(ctx.blockingTaskExecutor(), decodedMappedPath);
        })).thenApply(canList -> {
            if (canList.booleanValue()) {
                try (TemporaryThreadLocals ttl = TemporaryThreadLocals.acquire();){
                    StringBuilder locationBuilder = ttl.stringBuilder().append(ctx.path()).append('/');
                    if (ctx.query() != null) {
                        locationBuilder.append('?').append(ctx.query());
                    }
                    HttpFile httpFile = HttpFile.ofRedirect(locationBuilder.toString());
                    return httpFile;
                }
            }
            return HttpFile.nonExistent();
        });
    }

    private CompletableFuture<@Nullable HttpFile> findFileWithExtensions(ServiceRequestContext ctx, @Nullable Iterator<String> extensionIterator, String path, Set<ContentEncoding> supportedEncodings, boolean decompress) {
        if (extensionIterator == null || !extensionIterator.hasNext()) {
            return UnmodifiableFuture.completedFuture(null);
        }
        String extension = extensionIterator.next();
        return this.findFile(ctx, path + '.' + extension, supportedEncodings, decompress).thenCompose(file -> {
            if (file != null) {
                return UnmodifiableFuture.completedFuture(file);
            }
            return this.findFileWithExtensions(ctx, extensionIterator, path, supportedEncodings, decompress);
        });
    }

    private CompletableFuture<@Nullable HttpFile> findFileAndDecompress(ServiceRequestContext ctx, String path, Set<ContentEncoding> supportedEncodings) {
        return this.findFile(ctx, path, (ContentEncoding)null, false).thenCompose(file -> {
            if (file != null) {
                return UnmodifiableFuture.completedFuture(file);
            }
            return this.findFile(ctx, path, supportedEncodings.iterator(), true);
        });
    }

    private HttpFile cache(ServiceRequestContext ctx, PathAndEncoding pathAndEncoding, HttpFile uncachedFile, @Nullable ContentEncoding encoding, boolean decompress) {
        assert (this.cache != null);
        ContextAwareBlockingTaskExecutor executor = ctx.blockingTaskExecutor();
        ByteBufAllocator alloc = ctx.alloc();
        return HttpFile.from(((CompletableFuture)uncachedFile.aggregateWithPooledObjects(executor, alloc).thenApply(aggregated -> {
            if (decompress && encoding != null) {
                assert (aggregated instanceof HttpDataFile);
                aggregated = FileService.decompress((HttpDataFile)aggregated, encoding, alloc);
                HttpFileAttributes attrs = aggregated.attributes();
                assert (attrs != null);
                if (attrs.length() > (long)this.config.maxCacheEntrySizeBytes()) {
                    this.cache.invalidate(pathAndEncoding);
                    return aggregated.toHttpFile();
                }
            }
            this.cache.put(pathAndEncoding, (AggregatedHttpFile)aggregated);
            return aggregated.toHttpFile();
        })).exceptionally(cause -> {
            logger.warn("{} Failed to cache a file: {}", new Object[]{ctx, uncachedFile, Exceptions.peel(cause)});
            return uncachedFile;
        }));
    }

    private static HttpDataFile decompress(HttpDataFile compressed, ContentEncoding encoding, ByteBufAllocator alloc) {
        @Nullable HttpData content = compressed.content();
        if (content.isEmpty()) {
            return compressed;
        }
        StreamDecoder decoder = encoding.decoderFactory.newDecoder(alloc);
        HttpData decoded = HttpMessageAggregator.aggregateData(decoder.decode(content), decoder.finish(), alloc);
        HttpFileAttributes attributes = compressed.attributes();
        AggregatedHttpFileBuilder builder = AggregatedHttpFile.builder(decoded, attributes.lastModifiedMillis());
        builder.clock(compressed.clock());
        builder.date(compressed.isDateEnabled());
        builder.lastModified(compressed.isLastModifiedEnabled());
        builder.setHeaders((Iterable)compressed.headers());
        @Nullable BiFunction<String, HttpFileAttributes, String> entityFunction = compressed.entityTagFunction();
        if (entityFunction == null) {
            builder.entityTag(false);
        } else {
            builder.entityTag((BiFunction)entityFunction);
        }
        return (HttpDataFile)builder.build();
    }

    public HttpService orElse(HttpService nextService) {
        Objects.requireNonNull(nextService, "nextService");
        return new OrElseHttpService(this, nextService);
    }

    static enum ContentEncoding {
        BROTLI(".br", StreamDecoderFactory.brotli()),
        GZIP(".gz", StreamDecoderFactory.gzip()),
        SNAPPY(".sz", StreamDecoderFactory.snappy());

        static final Set<ContentEncoding> availableEncodings;
        private final String extension;
        final StreamDecoderFactory decoderFactory;

        private ContentEncoding(String extension, StreamDecoderFactory decoderFactory) {
            this.extension = extension;
            this.decoderFactory = decoderFactory;
        }

        static {
            availableEncodings = Brotli.isAvailable() ? Sets.immutableEnumSet((Enum)BROTLI, (Enum[])new ContentEncoding[]{GZIP, SNAPPY}) : Sets.immutableEnumSet((Enum)GZIP, (Enum[])new ContentEncoding[]{SNAPPY});
        }
    }

    private static final class PathAndEncoding {
        private final String path;
        @Nullable
        private final String contentEncoding;

        PathAndEncoding(String path, @Nullable String contentEncoding) {
            this.path = path;
            this.contentEncoding = contentEncoding;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PathAndEncoding)) {
                return false;
            }
            return this.path.equals(((PathAndEncoding)obj).path) && Objects.equals(this.contentEncoding, ((PathAndEncoding)obj).contentEncoding);
        }

        public int hashCode() {
            return this.path.hashCode() * 31 + Objects.hashCode(this.contentEncoding);
        }
    }

    private static final class OrElseHttpService
    implements HttpService {
        private final FileService first;
        private final HttpService second;

        OrElseHttpService(FileService first, HttpService second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void serviceAdded(ServiceConfig cfg) throws Exception {
            this.first.serviceAdded(cfg);
            this.second.serviceAdded(cfg);
        }

        @Override
        public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) {
            return HttpResponse.of((CompletableFuture<? extends HttpResponse>)this.first.findFile(ctx, req).readAttributes(ctx.blockingTaskExecutor()).thenApply(firstAttrs -> {
                try {
                    if (firstAttrs != null) {
                        return this.first.serve(ctx, req);
                    }
                    return this.second.serve(ctx, req);
                }
                catch (Exception e) {
                    return (HttpResponse)Exceptions.throwUnsafely(e);
                }
            }));
        }

        @Override
        public boolean shouldCachePath(String path, @Nullable String query, Route route) {
            return this.first.shouldCachePath(path, query, route) && this.second.shouldCachePath(path, query, route);
        }
    }
}

