/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.file;

import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Ascii;
import io.opentelemetry.testing.internal.armeria.server.file.MediaTypeResolver;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class DefaultMediaTypeResolver
extends Enum<DefaultMediaTypeResolver>
implements MediaTypeResolver {
    public static final /* enum */ DefaultMediaTypeResolver INSTANCE = new DefaultMediaTypeResolver();
    private static final Map<String, MediaType> EXTENSION_TO_MEDIA_TYPE;
    private static final /* synthetic */ DefaultMediaTypeResolver[] $VALUES;

    public static DefaultMediaTypeResolver[] values() {
        return (DefaultMediaTypeResolver[])$VALUES.clone();
    }

    public static DefaultMediaTypeResolver valueOf(String name) {
        return Enum.valueOf(DefaultMediaTypeResolver.class, name);
    }

    private static void add(Map<String, MediaType> extensionToMediaType, MediaType mediaType, String ... extensions) {
        for (String e : extensions) {
            assert (Ascii.toLowerCase(e).equals(e));
            extensionToMediaType.put(e, mediaType);
        }
    }

    @Nullable
    private static MediaType guessFromPath(String path) {
        Objects.requireNonNull(path, "path");
        int dotIdx = path.lastIndexOf(46);
        int slashIdx = path.lastIndexOf(47);
        if (dotIdx < 0 || slashIdx > dotIdx) {
            return null;
        }
        String extension = Ascii.toLowerCase(path.substring(dotIdx + 1));
        MediaType mediaType = EXTENSION_TO_MEDIA_TYPE.get(extension);
        if (mediaType != null) {
            return mediaType;
        }
        String guessedContentType = URLConnection.guessContentTypeFromName(path);
        return guessedContentType != null ? MediaType.parse(guessedContentType) : null;
    }

    @Override
    @Nullable
    public MediaType guessFromPath(String path, @Nullable String contentEncoding) {
        if (contentEncoding == null || Ascii.equalsIgnoreCase(contentEncoding, "identity")) {
            return DefaultMediaTypeResolver.guessFromPath(path);
        }
        Objects.requireNonNull(path, "path");
        return DefaultMediaTypeResolver.guessFromPath(path.substring(0, path.lastIndexOf(46)));
    }

    private static /* synthetic */ DefaultMediaTypeResolver[] $values() {
        return new DefaultMediaTypeResolver[]{INSTANCE};
    }

    static {
        $VALUES = DefaultMediaTypeResolver.$values();
        HashMap<String, MediaType> map = new HashMap<String, MediaType>();
        DefaultMediaTypeResolver.add(map, MediaType.CSS_UTF_8, "css");
        DefaultMediaTypeResolver.add(map, MediaType.HTML_UTF_8, "html", "htm");
        DefaultMediaTypeResolver.add(map, MediaType.PLAIN_TEXT_UTF_8, "txt");
        DefaultMediaTypeResolver.add(map, MediaType.AVIF, "avif");
        DefaultMediaTypeResolver.add(map, MediaType.GIF, "gif");
        DefaultMediaTypeResolver.add(map, MediaType.HEIF, "heif");
        DefaultMediaTypeResolver.add(map, MediaType.JPEG, "jpeg", "jpg");
        DefaultMediaTypeResolver.add(map, MediaType.PNG, "png");
        DefaultMediaTypeResolver.add(map, MediaType.SVG_UTF_8, "svg", "svgz");
        DefaultMediaTypeResolver.add(map, MediaType.WEBP, "webp");
        DefaultMediaTypeResolver.add(map, MediaType.create("image", "x-icon"), "ico");
        DefaultMediaTypeResolver.add(map, MediaType.create("application", "x-font-ttf"), "ttc", "ttf");
        DefaultMediaTypeResolver.add(map, MediaType.WOFF, "woff");
        DefaultMediaTypeResolver.add(map, MediaType.WOFF2, "woff2");
        DefaultMediaTypeResolver.add(map, MediaType.EOT, "eot");
        DefaultMediaTypeResolver.add(map, MediaType.create("font", "opentype"), "otf");
        DefaultMediaTypeResolver.add(map, MediaType.JAVASCRIPT_UTF_8, "js");
        DefaultMediaTypeResolver.add(map, MediaType.JSON_UTF_8, "json");
        DefaultMediaTypeResolver.add(map, MediaType.PDF, "pdf");
        DefaultMediaTypeResolver.add(map, MediaType.XHTML_UTF_8, "xhtml", "xhtm");
        DefaultMediaTypeResolver.add(map, MediaType.APPLICATION_XML_UTF_8, "xml", "xsd");
        DefaultMediaTypeResolver.add(map, MediaType.create("application", "xml-dtd"), "dtd");
        DefaultMediaTypeResolver.add(map, MediaType.MANIFEST_JSON_UTF_8, "webmanifest");
        EXTENSION_TO_MEDIA_TYPE = Collections.unmodifiableMap(map);
    }
}

