/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.cors;

import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.server.cors.AbstractCorsPolicyBuilder;
import io.opentelemetry.testing.internal.armeria.server.cors.CorsServiceBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public final class ChainedCorsPolicyBuilder
extends AbstractCorsPolicyBuilder<ChainedCorsPolicyBuilder> {
    private static final List<String> ALLOW_ANY_ORIGIN = ImmutableList.of("*");
    private final CorsServiceBuilder serviceBuilder;

    ChainedCorsPolicyBuilder(CorsServiceBuilder builder) {
        super(ALLOW_ANY_ORIGIN);
        Objects.requireNonNull(builder, "builder");
        this.serviceBuilder = builder;
    }

    ChainedCorsPolicyBuilder(CorsServiceBuilder builder, List<String> origins) {
        super(origins);
        Objects.requireNonNull(builder, "builder");
        this.serviceBuilder = builder;
    }

    ChainedCorsPolicyBuilder(CorsServiceBuilder builder, Predicate<? super String> originPredicate) {
        super(originPredicate);
        Objects.requireNonNull(builder, "builder");
        this.serviceBuilder = builder;
    }

    public CorsServiceBuilder and() {
        return this.serviceBuilder.addPolicy(this.build());
    }

    public ChainedCorsPolicyBuilder andForOrigins(String ... origins) {
        return this.and().andForOrigins(origins);
    }

    public ChainedCorsPolicyBuilder andForOrigin(String origin) {
        return this.and().andForOrigin(origin);
    }
}

