/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.auth;

import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.common.metric.MoreMeters;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.SimpleDecoratingHttpService;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthFailureHandler;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthServiceBuilder;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthSuccessHandler;
import io.opentelemetry.testing.internal.armeria.server.auth.Authorizer;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthorizerUtil;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Timer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthService
extends SimpleDecoratingHttpService {
    static final Logger logger = LoggerFactory.getLogger(AuthService.class);
    private final Authorizer<HttpRequest> authorizer;
    private final AuthSuccessHandler defaultSuccessHandler;
    private final AuthFailureHandler defaultFailureHandler;
    @Nullable
    private Timer successTimer;
    @Nullable
    private Timer failureTimer;
    private final MeterIdPrefix meterIdPrefix;

    public static Function<? super HttpService, AuthService> newDecorator(Iterable<? extends Authorizer<HttpRequest>> authorizers) {
        return AuthService.builder().add(authorizers).newDecorator();
    }

    @SafeVarargs
    public static Function<? super HttpService, AuthService> newDecorator(Authorizer<HttpRequest> ... authorizers) {
        return AuthService.newDecorator(ImmutableList.copyOf(Objects.requireNonNull(authorizers, "authorizers")));
    }

    public static AuthServiceBuilder builder() {
        return new AuthServiceBuilder();
    }

    AuthService(HttpService delegate, Authorizer<HttpRequest> authorizer, AuthSuccessHandler defaultSuccessHandler, AuthFailureHandler defaultFailureHandler, MeterIdPrefix meterIdPrefix) {
        super(delegate);
        this.authorizer = authorizer;
        this.defaultSuccessHandler = defaultSuccessHandler;
        this.defaultFailureHandler = defaultFailureHandler;
        this.meterIdPrefix = meterIdPrefix;
    }

    @Override
    public void serviceAdded(ServiceConfig cfg) throws Exception {
        super.serviceAdded(cfg);
        MeterRegistry meterRegistry = cfg.server().meterRegistry();
        this.successTimer = MoreMeters.newTimer(meterRegistry, this.meterIdPrefix.name(), this.meterIdPrefix.tags("result", "success"));
        this.failureTimer = MoreMeters.newTimer(meterRegistry, this.meterIdPrefix.name(), this.meterIdPrefix.tags("result", "failure"));
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        long startNanos = System.nanoTime();
        return HttpResponse.of(AuthorizerUtil.authorizeAndSupplyHandlers(this.authorizer, ctx, req).handleAsync((result, cause) -> {
            try {
                HttpService delegate = (HttpService)this.unwrap();
                if (cause == null) {
                    if (result != null) {
                        if (!result.isAuthorized()) {
                            return this.handleFailure(delegate, result.failureHandler(), ctx, req, null, startNanos);
                        }
                        return this.handleSuccess(delegate, result.successHandler(), ctx, req, startNanos);
                    }
                    cause = AuthorizerUtil.newNullResultException(this.authorizer);
                }
                return this.handleFailure(delegate, result != null ? result.failureHandler() : null, ctx, req, (Throwable)cause, startNanos);
            }
            catch (Exception e) {
                return (HttpResponse)Exceptions.throwUnsafely(e);
            }
        }, ctx.eventLoop()));
    }

    private HttpResponse handleSuccess(HttpService delegate, @Nullable AuthSuccessHandler authorizerSuccessHandler, ServiceRequestContext ctx, HttpRequest req, long startNanos) throws Exception {
        assert (this.successTimer != null);
        this.successTimer.record(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
        AuthSuccessHandler handler = authorizerSuccessHandler == null ? this.defaultSuccessHandler : authorizerSuccessHandler;
        return handler.authSucceeded(delegate, ctx, req);
    }

    private HttpResponse handleFailure(HttpService delegate, @Nullable AuthFailureHandler authorizerFailureHandler, ServiceRequestContext ctx, HttpRequest req, @Nullable Throwable cause, long startNanos) throws Exception {
        AuthFailureHandler handler;
        assert (this.failureTimer != null);
        this.failureTimer.record(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
        AuthFailureHandler authFailureHandler = handler = authorizerFailureHandler == null ? this.defaultFailureHandler : authorizerFailureHandler;
        if (cause != null) {
            cause = Exceptions.peel(cause);
        }
        return handler.authFailed(delegate, ctx, req, cause);
    }
}

