/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.server.ResponseConversionUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.ClassUtil;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.annotation.ResponseConverterFunction;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

public final class ByteArrayResponseConverterFunction
implements ResponseConverterFunction {
    @Override
    @Nullable
    public Boolean isResponseStreaming(Type returnType, @Nullable MediaType produceType) {
        Class<?> clazz = ClassUtil.typeToClass(ClassUtil.unwrapUnaryAsyncType(returnType));
        if (clazz == null) {
            return null;
        }
        if (HttpData.class.isAssignableFrom(clazz) || byte[].class.isAssignableFrom(clazz)) {
            return false;
        }
        if (produceType != null && (produceType.is(MediaType.APPLICATION_BINARY) || produceType.is(MediaType.OCTET_STREAM))) {
            return Publisher.class.isAssignableFrom(clazz) || Stream.class.isAssignableFrom(clazz);
        }
        return null;
    }

    @Override
    public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) throws Exception {
        MediaType contentType = headers.contentType();
        if (contentType != null) {
            if (contentType.is(MediaType.APPLICATION_BINARY) || contentType.is(MediaType.OCTET_STREAM)) {
                if (result instanceof Publisher) {
                    return ResponseConversionUtil.streamingFrom((Publisher)result, headers, trailers, ByteArrayResponseConverterFunction::toHttpData);
                }
                if (result instanceof Stream) {
                    return ResponseConversionUtil.streamingFrom((Stream)result, headers, trailers, ByteArrayResponseConverterFunction::toHttpData, ctx.blockingTaskExecutor());
                }
            }
            if (result instanceof HttpData) {
                return HttpResponse.of(headers, (HttpData)result, trailers);
            }
            if (result instanceof byte[]) {
                return HttpResponse.of(headers, HttpData.wrap((byte[])result), trailers);
            }
            return (HttpResponse)ResponseConverterFunction.fallthrough();
        }
        if (result instanceof HttpData) {
            return HttpResponse.of(headers.toBuilder().contentType(MediaType.OCTET_STREAM).build(), (HttpData)result, trailers);
        }
        if (result instanceof byte[]) {
            return HttpResponse.of(headers.toBuilder().contentType(MediaType.OCTET_STREAM).build(), HttpData.wrap((byte[])result), trailers);
        }
        return (HttpResponse)ResponseConverterFunction.fallthrough();
    }

    private static HttpData toHttpData(@Nullable Object value) {
        if (value instanceof HttpData) {
            return (HttpData)value;
        }
        if (value instanceof byte[]) {
            return HttpData.wrap((byte[])value);
        }
        if (value == null) {
            return HttpData.empty();
        }
        throw new IllegalStateException("Failed to convert an object to an HttpData: " + value.getClass().getName());
    }
}

