/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.internal.common.HttpHeadersUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.DefaultServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.AbstractHttpResponseSubscriber;
import io.opentelemetry.testing.internal.armeria.server.DecodedHttpRequest;
import io.opentelemetry.testing.internal.armeria.server.ServerConfig;
import io.opentelemetry.testing.internal.armeria.server.ServerHttpObjectEncoder;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletableFuture;

final class HttpResponseSubscriber
extends AbstractHttpResponseSubscriber {
    HttpResponseSubscriber(ChannelHandlerContext ctx, ServerHttpObjectEncoder responseEncoder, DefaultServiceRequestContext reqCtx, DecodedHttpRequest req, CompletableFuture<Void> completionFuture) {
        super(ctx, responseEncoder, reqCtx, req, completionFuture);
    }

    @Override
    void onResponseHeaders(ResponseHeaders headers) {
        ResponseHeaders merged;
        boolean endOfStream = headers.isEndOfStream();
        HttpStatus status = headers.status();
        if (status.isInformational()) {
            if (endOfStream) {
                this.req.abortResponse(new IllegalStateException("published an informational headers whose endOfStream is true: " + headers + " (service: " + this.service() + ')'), true);
                return;
            }
            merged = headers;
        } else {
            if (this.req.method() == HttpMethod.HEAD) {
                endOfStream = true;
            } else {
                if (!this.reqCtx.additionalResponseTrailers().isEmpty()) {
                    endOfStream = false;
                }
                if (status.isContentAlwaysEmpty()) {
                    this.setState(AbstractHttpResponseSubscriber.State.NEEDS_TRAILERS);
                } else {
                    this.setState(AbstractHttpResponseSubscriber.State.NEEDS_DATA_OR_TRAILERS);
                }
            }
            if (endOfStream) {
                this.setDone(true);
            }
            ServerConfig config = this.reqCtx.config().server().config();
            merged = HttpHeadersUtil.mergeResponseHeaders(headers, this.reqCtx.additionalResponseHeaders(), this.reqCtx.config().defaultHeaders(), config.isServerHeaderEnabled(), config.isDateHeaderEnabled());
            String connectionOption = merged.get(HttpHeaderNames.CONNECTION);
            if (HttpHeadersUtil.CLOSE_STRING.equalsIgnoreCase(connectionOption)) {
                this.disconnectWhenFinished();
            }
            this.logBuilder().responseHeaders(merged);
        }
        this.responseEncoder.writeHeaders(this.req.id(), this.req.streamId(), merged, endOfStream, this.reqCtx.additionalResponseTrailers().isEmpty(), this.req.method()).addListener((GenericFutureListener)this.writeHeadersFutureListener(endOfStream));
    }
}

