/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.server.HttpServerUpgradeHandler;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufUtil;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.handler.codec.base64.Base64;
import io.opentelemetry.testing.internal.io.netty.handler.codec.base64.Base64Dialect;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpRequest;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2CodecUtil;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Exception;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Flags;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2FrameAdapter;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2FrameReader;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Settings;
import io.opentelemetry.testing.internal.io.netty.util.CharsetUtil;
import java.nio.CharBuffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Http2ServerUpgradeCodec
implements HttpServerUpgradeHandler.UpgradeCodec {
    private static final Logger logger = LoggerFactory.getLogger(Http2ServerUpgradeCodec.class);
    private final Http2ConnectionHandler connectionHandler;
    private final Http2FrameReader frameReader;
    @Nullable
    private Http2Settings settings;

    Http2ServerUpgradeCodec(Http2ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
        this.frameReader = new DefaultHttp2FrameReader();
    }

    @Override
    public boolean prepareUpgradeResponse(ChannelHandlerContext ctx, HttpRequest upgradeRequest) {
        try {
            List<String> upgradeHeaders = upgradeRequest.headers().getAll(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
            if (upgradeHeaders.size() != 1) {
                throw new IllegalArgumentException("There must be 1 and only 1 " + Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER + " header.");
            }
            this.settings = this.decodeSettingsHeader(ctx, upgradeHeaders.get(0));
            return true;
        }
        catch (Throwable cause) {
            logger.info("Error during upgrade to HTTP/2", cause);
            return false;
        }
    }

    @Override
    public void upgradeTo(ChannelHandlerContext ctx) {
        try {
            ctx.pipeline().addAfter(ctx.name(), null, this.connectionHandler);
            this.connectionHandler.onHttpServerUpgrade(this.settings);
        }
        catch (Http2Exception e) {
            ctx.fireExceptionCaught(e);
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Http2Settings decodeSettingsHeader(ChannelHandlerContext ctx, CharSequence settingsHeader) throws Http2Exception {
        ByteBuf header = ByteBufUtil.encodeString(ctx.alloc(), CharBuffer.wrap(settingsHeader), CharsetUtil.UTF_8);
        try {
            ByteBuf payload = Base64.decode(header, Base64Dialect.URL_SAFE);
            ByteBuf frame = Http2ServerUpgradeCodec.createSettingsFrame(ctx, payload);
            Http2Settings http2Settings = this.decodeSettings(ctx, frame);
            return http2Settings;
        }
        finally {
            header.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Http2Settings decodeSettings(ChannelHandlerContext ctx, ByteBuf frame) throws Http2Exception {
        try {
            final Http2Settings decodedSettings = new Http2Settings();
            this.frameReader.readFrame(ctx, frame, new Http2FrameAdapter(){

                @Override
                public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
                    decodedSettings.copyFrom(settings);
                }
            });
            Http2Settings http2Settings = decodedSettings;
            return http2Settings;
        }
        finally {
            frame.release();
        }
    }

    private static ByteBuf createSettingsFrame(ChannelHandlerContext ctx, ByteBuf payload) {
        ByteBuf frame = ctx.alloc().buffer(9 + payload.readableBytes());
        Http2CodecUtil.writeFrameHeader(frame, payload.readableBytes(), (byte)4, new Http2Flags(), 0);
        frame.writeBytes(payload);
        payload.release();
        return frame;
    }
}

