/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.server.HttpResponseException;
import io.opentelemetry.testing.internal.armeria.server.HttpStatusException;
import io.opentelemetry.testing.internal.armeria.server.ServiceErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.UnloggedExceptionsReporter;

final class ExceptionReportingServiceErrorHandler
implements ServiceErrorHandler {
    private final ServiceErrorHandler delegate;
    private final UnloggedExceptionsReporter reporter;

    ExceptionReportingServiceErrorHandler(ServiceErrorHandler delegate, UnloggedExceptionsReporter reporter) {
        this.delegate = delegate;
        this.reporter = reporter;
    }

    @Override
    @Nullable
    public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
        HttpResponse httpResponse = this.delegate.onServiceException(ctx, cause);
        if (ctx.shouldReportUnloggedExceptions() && !ExceptionReportingServiceErrorHandler.isIgnorableException(cause)) {
            this.reporter.report(cause);
        }
        return httpResponse;
    }

    private static boolean isIgnorableException(Throwable cause) {
        if (Exceptions.isExpected(cause)) {
            return true;
        }
        return (cause instanceof HttpStatusException || cause instanceof HttpResponseException) && cause.getCause() == null;
    }

    @Override
    @Nullable
    public AggregatedHttpResponse renderStatus(ServiceRequestContext ctx, RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        return this.delegate.renderStatus(ctx, headers, status, description, cause);
    }
}

