/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.CorsHeaderUtil;
import io.opentelemetry.testing.internal.armeria.server.DecoratingServerErrorHandlerFunction;
import io.opentelemetry.testing.internal.armeria.server.ServerErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.cors.CorsService;

final class CorsServerErrorHandler
implements DecoratingServerErrorHandlerFunction {
    CorsServerErrorHandler() {
    }

    private static boolean shouldSetCorsHeaders(@Nullable CorsService corsService, ServiceRequestContext ctx) {
        if (corsService == null) {
            return false;
        }
        if (CorsHeaderUtil.isCorsHeadersSet(ctx)) {
            return false;
        }
        RequestHeaders headers = ctx.request().headers();
        if (ArmeriaHttpUtil.isCorsPreflightRequest(headers)) {
            return false;
        }
        return !CorsHeaderUtil.isForbiddenOrigin(corsService.config(), ctx, headers);
    }

    @Override
    @Nullable
    public HttpResponse onServiceException(ServerErrorHandler delegate, ServiceRequestContext ctx, Throwable cause) {
        CorsService corsService = ctx.findService(CorsService.class);
        if (CorsServerErrorHandler.shouldSetCorsHeaders(corsService, ctx)) {
            assert (corsService != null);
            ctx.mutateAdditionalResponseHeaders(builder -> CorsHeaderUtil.setCorsResponseHeaders(ctx, ctx.request(), builder, corsService.config()));
        }
        return delegate.onServiceException(ctx, cause);
    }
}

