/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.AggregationOptions;
import io.opentelemetry.testing.internal.armeria.common.ExchangeType;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.stream.AggregatingStreamMessage;
import io.opentelemetry.testing.internal.armeria.server.DecodedHttpRequestWriter;
import io.opentelemetry.testing.internal.armeria.server.Routed;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

final class AggregatingDecodedHttpRequest
extends AggregatingStreamMessage<HttpObject>
implements DecodedHttpRequestWriter {
    private final EventLoop eventLoop;
    private final int id;
    private final int streamId;
    private final boolean keepAlive;
    private final long maxRequestLength;
    private final RequestHeaders headers;
    private final RoutingContext routingCtx;
    private final ExchangeType exchangeType;
    private final long requestStartTimeNanos;
    private final long requestStartTimeMicros;
    @Nullable
    private ServiceRequestContext ctx;
    private long transferredBytes;
    @Nullable
    private HttpResponse response;
    @Nullable
    private Throwable abortResponseCause;
    private boolean isNormallyClosed;
    private final CompletableFuture<Void> aggregationFuture = new CompletableFuture();
    private final CompletableFuture<Void> whenResponseSent = new CompletableFuture();

    AggregatingDecodedHttpRequest(EventLoop eventLoop, int id, int streamId, RequestHeaders headers, boolean keepAlive, long maxRequestLength, RoutingContext routingCtx, ExchangeType exchangeType, long requestStartTimeNanos, long requestStartTimeMicros) {
        super(4);
        this.headers = headers;
        this.eventLoop = eventLoop;
        this.id = id;
        this.streamId = streamId;
        this.keepAlive = keepAlive;
        this.maxRequestLength = maxRequestLength;
        assert (routingCtx.hasResult());
        this.routingCtx = routingCtx;
        this.exchangeType = exchangeType;
        this.requestStartTimeNanos = requestStartTimeNanos;
        this.requestStartTimeMicros = requestStartTimeMicros;
    }

    @Override
    public void init(ServiceRequestContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public CompletableFuture<AggregatedHttpRequest> aggregate(AggregationOptions options) {
        return super.aggregate(options);
    }

    @Override
    @Nullable
    public ServiceRequestContext requestContext() {
        return this.ctx;
    }

    @Override
    public RoutingContext routingContext() {
        return this.routingCtx;
    }

    @Override
    @Nonnull
    public Routed<ServiceConfig> route() {
        return this.routingCtx.result();
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int streamId() {
        return this.streamId;
    }

    @Override
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public long maxRequestLength() {
        return this.ctx != null ? this.ctx.maxRequestLength() : this.maxRequestLength;
    }

    @Override
    public long transferredBytes() {
        return this.transferredBytes;
    }

    @Override
    public void increaseTransferredBytes(long delta) {
        this.transferredBytes = this.transferredBytes > Long.MAX_VALUE - delta ? Long.MAX_VALUE : (this.transferredBytes += delta);
    }

    @Override
    public EventLoop defaultSubscriberExecutor() {
        return this.eventLoop;
    }

    @Override
    public boolean tryWrite(HttpObject obj) {
        assert (this.ctx != null) : "uninitialized DecodedHttpRequest must be aborted.";
        boolean published = super.tryWrite(obj);
        if (obj instanceof HttpData) {
            HttpData httpData = (HttpData)obj;
            httpData.touch(this.ctx);
            this.ctx.logBuilder().increaseRequestLength(httpData);
            if (obj.isEndOfStream()) {
                this.close();
            }
        }
        if (obj instanceof HttpHeaders) {
            this.ctx.logBuilder().requestTrailers((HttpHeaders)obj);
            this.close();
        }
        return published;
    }

    @Override
    public void setResponse(HttpResponse response) {
        if (this.abortResponseCause != null) {
            if (!response.isComplete()) {
                response.abort(this.abortResponseCause);
            }
        } else {
            this.response = response;
        }
    }

    @Override
    public void abortResponse(Throwable cause, boolean cancel) {
        if (this.abortResponseCause != null) {
            return;
        }
        this.abortResponseCause = cause;
        super.close(cause);
        if (cancel && this.ctx != null) {
            this.ctx.cancel(cause);
        }
        this.aggregationFuture.complete(null);
        if (this.response != null && !this.response.isComplete()) {
            this.response.abort(cause);
        }
    }

    @Override
    public void close() {
        this.isNormallyClosed = true;
        super.close();
        this.aggregationFuture.complete(null);
    }

    @Override
    public void close(Throwable cause) {
        super.close(cause);
        this.aggregationFuture.complete(null);
    }

    @Override
    public boolean isClosedSuccessfully() {
        return this.isNormallyClosed;
    }

    @Override
    public void abort() {
        super.abort();
        this.aggregationFuture.complete(null);
    }

    @Override
    public void abort(Throwable cause) {
        super.abort(cause);
        this.aggregationFuture.complete(null);
    }

    @Override
    public boolean isResponseAborted() {
        return this.abortResponseCause != null;
    }

    @Override
    public CompletableFuture<Void> whenAggregated() {
        return this.aggregationFuture;
    }

    @Override
    public CompletableFuture<Void> whenResponseSent() {
        return this.whenResponseSent;
    }

    @Override
    public ExchangeType exchangeType() {
        return this.exchangeType;
    }

    @Override
    public long requestStartTimeNanos() {
        return this.requestStartTimeNanos;
    }

    @Override
    public long requestStartTimeMicros() {
        return this.requestStartTimeMicros;
    }

    @Override
    public RequestHeaders headers() {
        return this.headers;
    }
}

