/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.logging.RequestLog;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.TransientServiceOption;
import io.opentelemetry.testing.internal.armeria.server.logging.AccessLogWriter;

final class AccessLogWriterUtil {
    static void maybeWriteAccessLog(ServiceRequestContext reqCtx) {
        ServiceConfig config = reqCtx.config();
        if (AccessLogWriterUtil.shouldWriteAccessLog(config)) {
            reqCtx.log().whenComplete().thenAccept(log -> {
                try (SafeCloseable ignored = reqCtx.push();){
                    config.accessLogWriter().log((RequestLog)log);
                }
            });
        }
    }

    private static boolean shouldWriteAccessLog(ServiceConfig config) {
        return config.accessLogWriter() != AccessLogWriter.disabled() && config.transientServiceOptions().contains((Object)TransientServiceOption.WITH_ACCESS_LOGGING);
    }

    private AccessLogWriterUtil() {
    }
}

