/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.QueryParams;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterables;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Sets;
import io.opentelemetry.testing.internal.armeria.server.HttpHeaderUtil;
import io.opentelemetry.testing.internal.armeria.server.Route;
import io.opentelemetry.testing.internal.armeria.server.RouteBuilder;
import io.opentelemetry.testing.internal.armeria.server.RoutingPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

abstract class AbstractBindingBuilder<SELF extends AbstractBindingBuilder<SELF>> {
    static final Set<String> EMPTY_CONTEXT_PATHS = ImmutableSet.of("/");
    private Set<HttpMethod> methods = ImmutableSet.of();
    private Set<MediaType> consumeTypes = ImmutableSet.of();
    private Set<MediaType> produceTypes = ImmutableSet.of();
    private final List<RoutingPredicate<QueryParams>> paramPredicates = new ArrayList<RoutingPredicate<QueryParams>>();
    private final List<RoutingPredicate<HttpHeaders>> headerPredicates = new ArrayList<RoutingPredicate<HttpHeaders>>();
    private final Map<RouteBuilder, Set<HttpMethod>> routeBuilders = new LinkedHashMap<RouteBuilder, Set<HttpMethod>>();
    private final Set<RouteBuilder> pathBuilders = new LinkedHashSet<RouteBuilder>();
    private final List<Route> additionalRoutes = new ArrayList<Route>();
    private final List<Route> excludedRoutes = new ArrayList<Route>();
    private final Set<String> contextPaths;

    AbstractBindingBuilder(Set<String> contextPaths) {
        this.contextPaths = contextPaths;
    }

    Set<String> contextPaths() {
        return this.contextPaths;
    }

    SELF self() {
        return (SELF)this;
    }

    public SELF path(String pathPattern) {
        this.pathBuilders.add(Route.builder().path(Objects.requireNonNull(pathPattern, "pathPattern")));
        return this.self();
    }

    public SELF pathPrefix(String prefix) {
        this.pathBuilders.add(Route.builder().pathPrefix(Objects.requireNonNull(prefix, "prefix")));
        return this.self();
    }

    public SELF get(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.GET);
        return this.self();
    }

    public SELF post(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.POST);
        return this.self();
    }

    public SELF put(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.PUT);
        return this.self();
    }

    public SELF patch(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.PATCH);
        return this.self();
    }

    public SELF delete(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.DELETE);
        return this.self();
    }

    public SELF options(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.OPTIONS);
        return this.self();
    }

    public SELF head(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.HEAD);
        return this.self();
    }

    public SELF trace(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.TRACE);
        return this.self();
    }

    public SELF connect(String pathPattern) {
        this.addRouteBuilder(pathPattern, HttpMethod.CONNECT);
        return this.self();
    }

    private void addRouteBuilder(String pathPattern, HttpMethod method) {
        this.addRouteBuilder(Route.builder().path(Objects.requireNonNull(pathPattern, "pathPattern")), EnumSet.of(method));
    }

    private void addRouteBuilder(RouteBuilder routeBuilder, Set<HttpMethod> methods) {
        Set methodSet = this.routeBuilders.computeIfAbsent(routeBuilder, key -> EnumSet.noneOf(HttpMethod.class));
        for (HttpMethod method : methods) {
            if (methodSet.add(method)) continue;
            throw new IllegalArgumentException("duplicate HTTP method: " + (Object)((Object)method) + ", for: " + routeBuilder);
        }
    }

    public SELF methods(HttpMethod ... methods) {
        return this.methods(ImmutableSet.copyOf(Objects.requireNonNull(methods, "methods")));
    }

    public SELF methods(Iterable<HttpMethod> methods) {
        Objects.requireNonNull(methods, "methods");
        Preconditions.checkArgument(!Iterables.isEmpty(methods), "methods can't be empty.");
        this.methods = Sets.immutableEnumSet(methods);
        return this.self();
    }

    public SELF consumes(MediaType ... consumeTypes) {
        this.consumes(ImmutableSet.copyOf(Objects.requireNonNull(consumeTypes, "consumeTypes")));
        return this.self();
    }

    public SELF consumes(Iterable<MediaType> consumeTypes) {
        HttpHeaderUtil.ensureUniqueMediaTypes(consumeTypes, "consumeTypes");
        this.consumeTypes = ImmutableSet.copyOf(consumeTypes);
        return this.self();
    }

    public SELF produces(MediaType ... produceTypes) {
        this.produces(ImmutableSet.copyOf(Objects.requireNonNull(produceTypes, "produceTypes")));
        return this.self();
    }

    public SELF produces(Iterable<MediaType> produceTypes) {
        HttpHeaderUtil.ensureUniqueMediaTypes(produceTypes, "produceTypes");
        this.produceTypes = ImmutableSet.copyOf(produceTypes);
        return this.self();
    }

    public SELF matchesParams(String ... paramPredicates) {
        return this.matchesParams(ImmutableList.copyOf(Objects.requireNonNull(paramPredicates, "paramPredicates")));
    }

    public SELF matchesParams(Iterable<String> paramPredicates) {
        this.paramPredicates.addAll(RoutingPredicate.copyOfParamPredicates(Objects.requireNonNull(paramPredicates, "paramPredicates")));
        return this.self();
    }

    public SELF matchesParams(String paramName, Predicate<? super String> valuePredicate) {
        Objects.requireNonNull(paramName, "paramName");
        Objects.requireNonNull(valuePredicate, "valuePredicate");
        this.paramPredicates.add(RoutingPredicate.ofParams(paramName, valuePredicate));
        return this.self();
    }

    public SELF matchesHeaders(String ... headerPredicates) {
        return this.matchesHeaders(ImmutableList.copyOf(Objects.requireNonNull(headerPredicates, "headerPredicates")));
    }

    public SELF matchesHeaders(Iterable<String> headerPredicates) {
        this.headerPredicates.addAll(RoutingPredicate.copyOfHeaderPredicates(Objects.requireNonNull(headerPredicates, "headerPredicates")));
        return this.self();
    }

    public SELF matchesHeaders(CharSequence headerName, Predicate<? super String> valuePredicate) {
        Objects.requireNonNull(headerName, "headerName");
        Objects.requireNonNull(valuePredicate, "valuePredicate");
        this.headerPredicates.add(RoutingPredicate.ofHeaders(headerName, valuePredicate));
        return this.self();
    }

    public SELF addRoute(Route route) {
        this.additionalRoutes.add(Objects.requireNonNull(route, "route"));
        return this.self();
    }

    public SELF exclude(String pathPattern) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        this.excludedRoutes.add(Route.builder().path(pathPattern).build());
        return this.self();
    }

    public SELF exclude(Route excludedRoute) {
        this.excludedRoutes.add(Objects.requireNonNull(excludedRoute, "excludedRoute"));
        return this.self();
    }

    final List<Route> buildRouteList() {
        return this.buildRouteList(ImmutableSet.of());
    }

    final List<Route> buildRouteList(Collection<Route> fallbackRoutes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.additionalRoutes.isEmpty()) {
            if (this.pathBuilders.isEmpty() && this.routeBuilders.isEmpty()) {
                if (fallbackRoutes.isEmpty()) {
                    throw new IllegalStateException("Should set at least one path that the service is bound to before calling this.");
                }
                return ((ImmutableList.Builder)builder.addAll(fallbackRoutes)).build();
            }
            if (this.pathBuilders.isEmpty() && !this.methods.isEmpty()) {
                throw new IllegalStateException("Should set a path when the methods are set: " + this.methods);
            }
        }
        if (!this.pathBuilders.isEmpty()) {
            Set<HttpMethod> pathMethods = this.methods.isEmpty() ? HttpMethod.knownMethods() : this.methods;
            this.pathBuilders.forEach(pathBuilder -> this.addRouteBuilder((RouteBuilder)pathBuilder, pathMethods));
        }
        this.routeBuilders.forEach((routeBuilder, routeMethods) -> builder.add(routeBuilder.methods((Iterable<HttpMethod>)routeMethods).consumes(this.consumeTypes).produces(this.produceTypes).matchesParams(this.paramPredicates).matchesHeaders(this.headerPredicates).exclude(this.excludedRoutes).build()));
        this.additionalRoutes.forEach(builder::add);
        return builder.build();
    }
}

