/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.testing;

import io.opentelemetry.testing.internal.armeria.common.TlsKeyPair;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.util.SelfSignedCertificate;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.io.File;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Objects;

public final class SelfSignedCertificateRuleDelegate {
    @Nullable
    private final String fqdn;
    @Nullable
    private final SecureRandom random;
    @Nullable
    private final Integer bits;
    @Nullable
    private final Instant notBefore;
    @Nullable
    private final Instant notAfter;
    @Nullable
    private SelfSignedCertificate certificate;
    @Nullable
    private TlsKeyPair tlsKeyPair;

    public SelfSignedCertificateRuleDelegate() {
        this.fqdn = null;
        this.random = null;
        this.bits = null;
        this.notBefore = null;
        this.notAfter = null;
    }

    public SelfSignedCertificateRuleDelegate(TemporalAccessor notBefore, TemporalAccessor notAfter) {
        this.fqdn = null;
        this.random = null;
        this.bits = null;
        this.notBefore = Instant.from(Objects.requireNonNull(notBefore, "notBefore"));
        this.notAfter = Instant.from(Objects.requireNonNull(notAfter, "notAfter"));
    }

    public SelfSignedCertificateRuleDelegate(String fqdn) {
        this.fqdn = Objects.requireNonNull(fqdn, "fqdn");
        this.random = null;
        this.bits = null;
        this.notBefore = null;
        this.notAfter = null;
    }

    public SelfSignedCertificateRuleDelegate(String fqdn, TemporalAccessor notBefore, TemporalAccessor notAfter) {
        this.fqdn = Objects.requireNonNull(fqdn, "fqdn");
        this.random = null;
        this.bits = null;
        this.notBefore = Instant.from(Objects.requireNonNull(notBefore, "notBefore"));
        this.notAfter = Instant.from(Objects.requireNonNull(notAfter, "notAfter"));
    }

    public SelfSignedCertificateRuleDelegate(String fqdn, SecureRandom random, int bits) {
        this.fqdn = Objects.requireNonNull(fqdn, "fqdn");
        this.random = Objects.requireNonNull(random, "random");
        this.bits = bits;
        this.notBefore = null;
        this.notAfter = null;
    }

    public SelfSignedCertificateRuleDelegate(String fqdn, SecureRandom random, int bits, TemporalAccessor notBefore, TemporalAccessor notAfter) {
        this.fqdn = Objects.requireNonNull(fqdn, "fqdn");
        this.random = Objects.requireNonNull(random, "random");
        this.bits = bits;
        this.notBefore = Instant.from(Objects.requireNonNull(notBefore, "notBefore"));
        this.notAfter = Instant.from(Objects.requireNonNull(notAfter, "notAfter"));
    }

    public void before() throws Throwable {
        this.certificate = this.fqdn == null ? (this.notBefore == null || this.notAfter == null ? new SelfSignedCertificate() : new SelfSignedCertificate(SelfSignedCertificateRuleDelegate.toDate(this.notBefore), SelfSignedCertificateRuleDelegate.toDate(this.notAfter))) : (this.random == null || this.bits == null ? (this.notBefore == null || this.notAfter == null ? new SelfSignedCertificate(this.fqdn) : new SelfSignedCertificate(this.fqdn, SelfSignedCertificateRuleDelegate.toDate(this.notBefore), SelfSignedCertificateRuleDelegate.toDate(this.notAfter))) : (this.notBefore == null || this.notAfter == null ? new SelfSignedCertificate(this.fqdn, this.random, (int)this.bits) : new SelfSignedCertificate(this.fqdn, this.random, this.bits, SelfSignedCertificateRuleDelegate.toDate(this.notBefore), SelfSignedCertificateRuleDelegate.toDate(this.notAfter))));
    }

    private static Date toDate(Instant notBefore) {
        return new Date(notBefore.toEpochMilli());
    }

    public void after() {
        if (this.certificate != null) {
            this.certificate.delete();
        }
    }

    public X509Certificate certificate() {
        return this.ensureCertificate().cert();
    }

    public File certificateFile() {
        return this.ensureCertificate().certificate();
    }

    public PrivateKey privateKey() {
        return this.ensureCertificate().key();
    }

    public File privateKeyFile() {
        return this.ensureCertificate().privateKey();
    }

    public TlsKeyPair tlsKeyPair() {
        if (this.tlsKeyPair == null) {
            this.tlsKeyPair = TlsKeyPair.of(this.privateKey(), this.certificate());
        }
        return this.tlsKeyPair;
    }

    private SelfSignedCertificate ensureCertificate() {
        Preconditions.checkState(this.certificate != null, "certificate not created");
        return this.certificate;
    }
}

