/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.jctools.counters;

import io.opentelemetry.testing.internal.armeria.internal.shaded.jctools.counters.FixedSizeStripedLongCounter;
import io.opentelemetry.testing.internal.armeria.internal.shaded.jctools.util.UnsafeAccess;

class FixedSizeStripedLongCounterV6
extends FixedSizeStripedLongCounter {
    public FixedSizeStripedLongCounterV6(int stripesCount) {
        super(stripesCount);
    }

    @Override
    protected void inc(long[] cells, long offset, long delta) {
        long v;
        while (!UnsafeAccess.UNSAFE.compareAndSwapLong(cells, offset, v = UnsafeAccess.UNSAFE.getLongVolatile(cells, offset), v + delta)) {
        }
    }

    @Override
    protected long getAndReset(long[] cells, long offset) {
        long v;
        while (!UnsafeAccess.UNSAFE.compareAndSwapLong(cells, offset, v = UnsafeAccess.UNSAFE.getLongVolatile(cells, offset), 0L)) {
        }
        return v;
    }
}

