/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect;

import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMultiset;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Maps;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Multiset;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Multisets;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.primitives.Ints;
import io.opentelemetry.testing.internal.errorprone.annotations.concurrent.LazyInit;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

final class JdkBackedImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private final Map<E, Integer> delegateMap;
    private final ImmutableList<Multiset.Entry<E>> entries;
    private final long size;
    @LazyInit
    private transient @Nullable ImmutableSet<E> elementSet;

    static <E> ImmutableMultiset<E> create(Collection<? extends Multiset.Entry<? extends E>> entries) {
        Object[] entriesArray = entries.toArray(new Multiset.Entry[0]);
        HashMap delegateMap = Maps.newHashMapWithExpectedSize(entriesArray.length);
        long size = 0L;
        for (int i = 0; i < entriesArray.length; ++i) {
            Multiset.Entry entry = entriesArray[i];
            int count = entry.getCount();
            size += (long)count;
            Object element = Preconditions.checkNotNull(entry.getElement());
            delegateMap.put(element, count);
            if (entry instanceof Multisets.ImmutableEntry) continue;
            entriesArray[i] = Multisets.immutableEntry(element, count);
        }
        return new JdkBackedImmutableMultiset(delegateMap, ImmutableList.asImmutableList(entriesArray), size);
    }

    private JdkBackedImmutableMultiset(Map<E, Integer> delegateMap, ImmutableList<Multiset.Entry<E>> entries, long size) {
        this.delegateMap = delegateMap;
        this.entries = entries;
        this.size = size;
    }

    @Override
    public int count(@Nullable Object element) {
        return this.delegateMap.getOrDefault(element, 0);
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ImmutableSet<E> result = this.elementSet;
        return result == null ? (this.elementSet = new ImmutableMultiset.ElementSet<E>(this.entries, this)) : result;
    }

    @Override
    Multiset.Entry<E> getEntry(int index) {
        return (Multiset.Entry)this.entries.get(index);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }
}

