/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.booleans;

import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.Arrays;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.Hash;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.booleans.BooleanComparator;
import java.io.Serializable;

public final class BooleanArrays {
    public static final boolean[] EMPTY_ARRAY = new boolean[0];
    public static final boolean[] DEFAULT_EMPTY_ARRAY = new boolean[0];
    public static final Hash.Strategy<boolean[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(boolean[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    public static void swap(boolean[] x, int a, int b) {
        boolean t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static void swap(boolean[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            BooleanArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(boolean[] x, int a, int b, int c, BooleanComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(boolean[] a, int from, int to, BooleanComparator comp) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            boolean u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(boolean[] a, int from, int to, BooleanComparator comp) {
        int i = from;
        while (++i < to) {
            boolean t = a[i];
            int j = i;
            boolean u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(boolean[] x, int from, int to, BooleanComparator comp) {
        int c;
        int a;
        int len = to - from;
        if (len < 16) {
            BooleanArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = BooleanArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = BooleanArrays.med3(x, m - s, m, m + s, comp);
            n = BooleanArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = BooleanArrays.med3(x, l, m, n, comp);
        boolean v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            BooleanArrays.swap(x, b++, c--);
        }
        int s = Math.min(a - from, b - a);
        BooleanArrays.swap(x, from, b - s, s);
        s = Math.min(d - c, to - d - 1);
        BooleanArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            BooleanArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1) {
            BooleanArrays.quickSort(x, to - s, to, comp);
        }
    }

    private static int med3(boolean[] x, int a, int b, int c) {
        int ab = Boolean.compare(x[a], x[b]);
        int ac = Boolean.compare(x[a], x[c]);
        int bc = Boolean.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(boolean[] a, int from, int to) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (a[j] || !a[m]) continue;
                m = j;
            }
            if (m == i) continue;
            boolean u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    public static void quickSort(boolean[] x, int from, int to) {
        int c;
        int a;
        int len = to - from;
        if (len < 16) {
            BooleanArrays.selectionSort(x, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = BooleanArrays.med3(x, l, l + s, l + 2 * s);
            m = BooleanArrays.med3(x, m - s, m, m + s);
            n = BooleanArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = BooleanArrays.med3(x, l, m, n);
        boolean v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Boolean.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Boolean.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            BooleanArrays.swap(x, b++, c--);
        }
        int s = Math.min(a - from, b - a);
        BooleanArrays.swap(x, from, b - s, s);
        s = Math.min(d - c, to - d - 1);
        BooleanArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            BooleanArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1) {
            BooleanArrays.quickSort(x, to - s, to);
        }
    }

    public static void unstableSort(boolean[] a, int from, int to) {
        BooleanArrays.quickSort(a, from, to);
    }

    public static void unstableSort(boolean[] a) {
        BooleanArrays.unstableSort(a, 0, a.length);
    }

    public static void unstableSort(boolean[] a, int from, int to, BooleanComparator comp) {
        BooleanArrays.quickSort(a, from, to, comp);
    }

    public static void unstableSort(boolean[] a, BooleanComparator comp) {
        BooleanArrays.unstableSort(a, 0, a.length, comp);
    }

    public static void mergeSort(boolean[] a, int from, int to, BooleanComparator comp, boolean[] supp) {
        int len = to - from;
        if (len < 16) {
            BooleanArrays.insertionSort(a, from, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a, to);
        }
        int mid = from + to >>> 1;
        BooleanArrays.mergeSort(supp, from, mid, comp, a);
        BooleanArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(boolean[] a, int from, int to, BooleanComparator comp) {
        BooleanArrays.mergeSort(a, from, to, comp, null);
    }

    public static void stableSort(boolean[] a, int from, int to, BooleanComparator comp) {
        BooleanArrays.mergeSort(a, from, to, comp);
    }

    public static void stableSort(boolean[] a, BooleanComparator comp) {
        BooleanArrays.stableSort(a, 0, a.length, comp);
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<boolean[]>,
    Serializable {
        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(boolean[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(boolean[] a, boolean[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

