/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.ntru;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Set;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.interfaces.NTRUKey;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.PrivateKey;

public class BCNTRUPrivateKey
implements NTRUKey,
PrivateKey {
    private transient NTRUPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCNTRUPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (NTRUPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCNTRUPrivateKey) {
            BCNTRUPrivateKey bCNTRUPrivateKey = (BCNTRUPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCNTRUPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "NTRU";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }
}

