/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.slhdsa;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.slhdsa.PK;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.slhdsa.SK;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.slhdsa.SLHDSAKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.slhdsa.SLHDSAParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;

public class SLHDSAPrivateKeyParameters
extends SLHDSAKeyParameters {
    final SK sk;
    final PK pk;

    public SLHDSAPrivateKeyParameters(SLHDSAParameters sLHDSAParameters, byte[] byArray) {
        super(true, sLHDSAParameters);
        int n = sLHDSAParameters.getN();
        if (byArray.length != 4 * n) {
            throw new IllegalArgumentException("private key encoding does not match parameters");
        }
        this.sk = new SK(Arrays.copyOfRange(byArray, 0, n), Arrays.copyOfRange(byArray, n, 2 * n));
        this.pk = new PK(Arrays.copyOfRange(byArray, 2 * n, 3 * n), Arrays.copyOfRange(byArray, 3 * n, 4 * n));
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(new byte[][]{this.sk.seed, this.sk.prf, this.pk.seed, this.pk.root});
    }
}

