/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem.MLKEMEngine;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem.Poly;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem.PolyVec;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem.Symmetric;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;

class MLKEMIndCpa {
    private MLKEMEngine engine;
    private int kyberK;
    private int indCpaPublicKeyBytes;
    private int polyVecBytes;
    private int indCpaBytes;
    private int polyVecCompressedBytes;
    private int polyCompressedBytes;
    private Symmetric symmetric;
    public final int KyberGenerateMatrixNBlocks;

    public MLKEMIndCpa(MLKEMEngine mLKEMEngine) {
        this.engine = mLKEMEngine;
        this.kyberK = mLKEMEngine.getKyberK();
        this.indCpaPublicKeyBytes = mLKEMEngine.getKyberPublicKeyBytes();
        this.polyVecBytes = mLKEMEngine.getKyberPolyVecBytes();
        this.indCpaBytes = mLKEMEngine.getKyberIndCpaBytes();
        this.polyVecCompressedBytes = mLKEMEngine.getKyberPolyVecCompressedBytes();
        this.polyCompressedBytes = mLKEMEngine.getKyberPolyCompressedBytes();
        this.symmetric = mLKEMEngine.getSymmetric();
        this.KyberGenerateMatrixNBlocks = (472 + this.symmetric.xofBlockBytes) / this.symmetric.xofBlockBytes;
    }

    byte[][] generateKeyPair(byte[] byArray) {
        int n;
        PolyVec polyVec = new PolyVec(this.engine);
        PolyVec polyVec2 = new PolyVec(this.engine);
        PolyVec polyVec3 = new PolyVec(this.engine);
        byte[] byArray2 = new byte[64];
        this.symmetric.hash_g(byArray2, Arrays.append(byArray, (byte)this.kyberK));
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = new byte[32];
        System.arraycopy(byArray2, 0, byArray3, 0, 32);
        System.arraycopy(byArray2, 32, byArray4, 0, 32);
        byte by = 0;
        PolyVec[] polyVecArray = new PolyVec[this.kyberK];
        for (n = 0; n < this.kyberK; ++n) {
            polyVecArray[n] = new PolyVec(this.engine);
        }
        this.generateMatrix(polyVecArray, byArray3, false);
        for (n = 0; n < this.kyberK; ++n) {
            polyVec.getVectorIndex(n).getEta1Noise(byArray4, by);
            by = (byte)(by + 1);
        }
        for (n = 0; n < this.kyberK; ++n) {
            polyVec3.getVectorIndex(n).getEta1Noise(byArray4, by);
            by = (byte)(by + 1);
        }
        polyVec.polyVecNtt();
        polyVec3.polyVecNtt();
        for (n = 0; n < this.kyberK; ++n) {
            PolyVec.pointwiseAccountMontgomery(polyVec2.getVectorIndex(n), polyVecArray[n], polyVec, this.engine);
            polyVec2.getVectorIndex(n).convertToMont();
        }
        polyVec2.addPoly(polyVec3);
        polyVec2.reducePoly();
        return new byte[][]{this.packPublicKey(polyVec2, byArray3), this.packSecretKey(polyVec)};
    }

    public byte[] packPublicKey(PolyVec polyVec, byte[] byArray) {
        byte[] byArray2 = new byte[this.indCpaPublicKeyBytes];
        System.arraycopy(polyVec.toBytes(), 0, byArray2, 0, this.polyVecBytes);
        System.arraycopy(byArray, 0, byArray2, this.polyVecBytes, 32);
        return byArray2;
    }

    public byte[] packSecretKey(PolyVec polyVec) {
        return polyVec.toBytes();
    }

    public void generateMatrix(PolyVec[] polyVecArray, byte[] byArray, boolean bl) {
        byte[] byArray2 = new byte[this.KyberGenerateMatrixNBlocks * this.symmetric.xofBlockBytes + 2];
        for (int i = 0; i < this.kyberK; ++i) {
            for (int j = 0; j < this.kyberK; ++j) {
                if (bl) {
                    this.symmetric.xofAbsorb(byArray, (byte)i, (byte)j);
                } else {
                    this.symmetric.xofAbsorb(byArray, (byte)j, (byte)i);
                }
                this.symmetric.xofSqueezeBlocks(byArray2, 0, this.symmetric.xofBlockBytes * this.KyberGenerateMatrixNBlocks);
                int n = this.KyberGenerateMatrixNBlocks * this.symmetric.xofBlockBytes;
                for (int k = MLKEMIndCpa.rejectionSampling(polyVecArray[i].getVectorIndex(j), 0, 256, byArray2, n); k < 256; k += MLKEMIndCpa.rejectionSampling(polyVecArray[i].getVectorIndex(j), k, 256 - k, byArray2, n)) {
                    int n2 = n % 3;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        byArray2[i2] = byArray2[n - n2 + i2];
                    }
                    this.symmetric.xofSqueezeBlocks(byArray2, n2, this.symmetric.xofBlockBytes * 2);
                    n = n2 + this.symmetric.xofBlockBytes;
                }
            }
        }
    }

    private static int rejectionSampling(Poly poly, int n, int n2, byte[] byArray, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2 && n4 + 3 <= n3) {
            short s = (short)(((short)(byArray[n4] & 0xFF) >> 0 | (short)(byArray[n4 + 1] & 0xFF) << 8) & 0xFFF);
            short s2 = (short)(((short)(byArray[n4 + 1] & 0xFF) >> 4 | (short)(byArray[n4 + 2] & 0xFF) << 4) & 0xFFF);
            n4 += 3;
            if (s < 3329) {
                poly.setCoeffIndex(n + n5, s);
                ++n5;
            }
            if (n5 >= n2 || s2 >= 3329) continue;
            poly.setCoeffIndex(n + n5, s2);
            ++n5;
        }
        return n5;
    }
}

