/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa.Poly;

class PolyVecK {
    private final Poly[] vec;

    PolyVecK(MLDSAEngine mLDSAEngine) {
        int n = mLDSAEngine.getDilithiumK();
        this.vec = new Poly[n];
        for (int i = 0; i < n; ++i) {
            this.vec[i] = new Poly(mLDSAEngine);
        }
    }

    Poly getVectorIndex(int n) {
        return this.vec[n];
    }

    public void uniformEta(byte[] byArray, short s) {
        short s2 = s;
        for (int i = 0; i < this.vec.length; ++i) {
            short s3 = s2;
            s2 = (short)(s2 + 1);
            this.vec[i].uniformEta(byArray, s3);
        }
    }

    public void reduce() {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).reduce();
        }
    }

    public void invNttToMont() {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).invNttToMont();
        }
    }

    public void addPolyVecK(PolyVecK polyVecK) {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).addPoly(polyVecK.getVectorIndex(i));
        }
    }

    public void conditionalAddQ() {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).conditionalAddQ();
        }
    }

    public void power2Round(PolyVecK polyVecK) {
        for (int i = 0; i < this.vec.length; ++i) {
            this.getVectorIndex(i).power2Round(polyVecK.getVectorIndex(i));
        }
    }

    public String toString() {
        String string = "[";
        for (int i = 0; i < this.vec.length; ++i) {
            string = string + i + " " + this.getVectorIndex(i).toString();
            if (i == this.vec.length - 1) continue;
            string = string + ",\n";
        }
        string = string + "]";
        return string;
    }
}

