/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa.MLDSAKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mldsa.MLDSAPublicKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;

public class MLDSAPrivateKeyParameters
extends MLDSAKeyParameters {
    final byte[] rho;
    final byte[] k;
    final byte[] tr;
    final byte[] s1;
    final byte[] s2;
    final byte[] t0;
    private final byte[] t1;
    private final byte[] seed;
    private final int prefFormat;

    public MLDSAPrivateKeyParameters(MLDSAParameters mLDSAParameters, byte[] byArray, MLDSAPublicKeyParameters mLDSAPublicKeyParameters) {
        super(true, mLDSAParameters);
        MLDSAEngine mLDSAEngine = mLDSAParameters.getEngine(null);
        if (byArray.length == 32) {
            byte[][] byArray2 = mLDSAEngine.generateKeyPairInternal(byArray);
            this.rho = byArray2[0];
            this.k = byArray2[1];
            this.tr = byArray2[2];
            this.s1 = byArray2[3];
            this.s2 = byArray2[4];
            this.t0 = byArray2[5];
            this.t1 = byArray2[6];
            this.seed = byArray2[7];
        } else {
            int n = 0;
            this.rho = Arrays.copyOfRange(byArray, 0, 32);
            this.k = Arrays.copyOfRange(byArray, n += 32, n + 32);
            this.tr = Arrays.copyOfRange(byArray, n += 32, n + 64);
            int n2 = mLDSAEngine.getDilithiumL() * mLDSAEngine.getDilithiumPolyEtaPackedBytes();
            this.s1 = Arrays.copyOfRange(byArray, n += 64, n + n2);
            n += n2;
            n2 = mLDSAEngine.getDilithiumK() * mLDSAEngine.getDilithiumPolyEtaPackedBytes();
            this.s2 = Arrays.copyOfRange(byArray, n, n + n2);
            n += n2;
            n2 = mLDSAEngine.getDilithiumK() * 416;
            this.t0 = Arrays.copyOfRange(byArray, n, n + n2);
            n += n2;
            this.t1 = mLDSAEngine.deriveT1(this.rho, this.k, this.tr, this.s1, this.s2, this.t0);
            this.seed = null;
        }
        if (mLDSAPublicKeyParameters != null && !Arrays.constantTimeAreEqual(this.t1, mLDSAPublicKeyParameters.getT1())) {
            throw new IllegalArgumentException("passed in public key does not match private values");
        }
        this.prefFormat = this.seed != null ? 0 : 2;
    }

    public int getPreferredFormat() {
        return this.prefFormat;
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(new byte[][]{this.rho, this.k, this.tr, this.s1, this.s2, this.t0});
    }

    public byte[] getSeed() {
        return Arrays.clone(this.seed);
    }
}

