/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.ec;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.CryptoServicesRegistrar;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests.Blake2bDigest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests.Blake2sDigest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests.MD5Digest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests.RIPEMD160Digest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests.SHA1Digest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests.SHA224Digest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests.SHA256Digest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests.SHA384Digest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests.SHA512Digest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests.WhirlpoolDigest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.engines.SM2Engine;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params.ParametersWithRandom;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.ec.ECUtils;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.jcajce.provider.util.BadBlockException;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.jcajce.util.BCJcaJceHelper;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.jcajce.util.JcaJceHelper;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.jce.interfaces.ECKey;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class GMCipherSpi
extends CipherSpi {
    private final JcaJceHelper helper = new BCJcaJceHelper();
    private SM2Engine engine;
    private int state = -1;
    private ErasableOutputStream buffer = new ErasableOutputStream();
    private AsymmetricKeyParameter key;
    private SecureRandom random;

    public GMCipherSpi(SM2Engine sM2Engine) {
        this.engine = sM2Engine;
    }

    @Override
    public int engineGetBlockSize() {
        return 0;
    }

    @Override
    public int engineGetKeySize(Key key) {
        if (key instanceof ECKey) {
            return ((ECKey)((Object)key)).getParameters().getCurve().getFieldSize();
        }
        throw new IllegalArgumentException("not an EC key");
    }

    @Override
    public byte[] engineGetIV() {
        return null;
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        String string2 = Strings.toUpperCase(string);
        if (!string2.equals("NONE")) {
            throw new IllegalArgumentException("can't support mode " + string);
        }
    }

    @Override
    public int engineGetOutputSize(int n) {
        if (this.state == 1 || this.state == 3) {
            return this.engine.getOutputSize(n);
        }
        if (this.state == 2 || this.state == 4) {
            return this.engine.getOutputSize(n);
        }
        throw new IllegalStateException("cipher not initialised");
    }

    @Override
    public void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = Strings.toUpperCase(string);
        if (!string2.equals("NOPADDING")) {
            throw new NoSuchPaddingException("padding not available with IESCipher");
        }
    }

    @Override
    public void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException("cannot recognise parameters: " + algorithmParameters.getClass().getName());
        }
        this.engineInit(n, key, algorithmParameterSpec, secureRandom);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (n == 1 || n == 3) {
            if (!(key instanceof PublicKey)) throw new InvalidKeyException("must be passed public EC key for encryption");
            this.key = ECUtils.generatePublicKeyParameter((PublicKey)key);
        } else {
            if (n != 2 && n != 4) throw new InvalidKeyException("must be passed EC key");
            if (!(key instanceof PrivateKey)) throw new InvalidKeyException("must be passed private EC key for decryption");
            this.key = ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        }
        this.random = secureRandom != null ? secureRandom : CryptoServicesRegistrar.getSecureRandom();
        this.state = n;
        this.buffer.reset();
    }

    @Override
    public void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException("cannot handle supplied parameter spec: " + invalidAlgorithmParameterException.getMessage());
        }
    }

    @Override
    public byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.buffer.write(byArray, n, n2);
        return null;
    }

    @Override
    public int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.buffer.write(byArray, n, n2);
        return 0;
    }

    @Override
    public byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        block11: {
            if (n2 != 0) {
                this.buffer.write(byArray, n, n2);
            }
            if (this.state == 1 || this.state == 3) {
                try {
                    this.engine.init(true, new ParametersWithRandom(this.key, this.random));
                    byte[] byArray2 = this.engine.processBlock(this.buffer.getBuf(), 0, this.buffer.size());
                    return byArray2;
                }
                catch (Exception exception) {
                    throw new BadBlockException("unable to process block", exception);
                }
            }
            if (this.state != 2 && this.state != 4) break block11;
            try {
                this.engine.init(false, this.key);
                byte[] byArray3 = this.engine.processBlock(this.buffer.getBuf(), 0, this.buffer.size());
                return byArray3;
            }
            catch (Exception exception) {
                throw new BadBlockException("unable to process block", exception);
            }
        }
        throw new IllegalStateException("cipher not initialised");
        finally {
            this.buffer.erase();
        }
    }

    @Override
    public int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3 = this.engineDoFinal(byArray, n, n2);
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    protected static final class ErasableOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuf() {
            return this.buf;
        }

        public void erase() {
            Arrays.fill(this.buf, (byte)0);
            this.reset();
        }
    }

    public static class SM2
    extends GMCipherSpi {
        public SM2() {
            super(new SM2Engine());
        }
    }

    public static class SM2withBlake2b
    extends GMCipherSpi {
        public SM2withBlake2b() {
            super(new SM2Engine(new Blake2bDigest(512)));
        }
    }

    public static class SM2withBlake2s
    extends GMCipherSpi {
        public SM2withBlake2s() {
            super(new SM2Engine(new Blake2sDigest(256)));
        }
    }

    public static class SM2withMD5
    extends GMCipherSpi {
        public SM2withMD5() {
            super(new SM2Engine(new MD5Digest()));
        }
    }

    public static class SM2withRMD
    extends GMCipherSpi {
        public SM2withRMD() {
            super(new SM2Engine(new RIPEMD160Digest()));
        }
    }

    public static class SM2withSha1
    extends GMCipherSpi {
        public SM2withSha1() {
            super(new SM2Engine(new SHA1Digest()));
        }
    }

    public static class SM2withSha224
    extends GMCipherSpi {
        public SM2withSha224() {
            super(new SM2Engine(new SHA224Digest()));
        }
    }

    public static class SM2withSha256
    extends GMCipherSpi {
        public SM2withSha256() {
            super(new SM2Engine(SHA256Digest.newInstance()));
        }
    }

    public static class SM2withSha384
    extends GMCipherSpi {
        public SM2withSha384() {
            super(new SM2Engine(new SHA384Digest()));
        }
    }

    public static class SM2withSha512
    extends GMCipherSpi {
        public SM2withSha512() {
            super(new SM2Engine(new SHA512Digest()));
        }
    }

    public static class SM2withWhirlpool
    extends GMCipherSpi {
        public SM2withWhirlpool() {
            super(new SM2Engine(new WhirlpoolDigest()));
        }
    }
}

