/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.generators;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.AsymmetricCipherKeyPair;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.CryptoServicePurpose;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.CryptoServicesRegistrar;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.KeyGenerationParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.constraints.ConstraintUtils;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.constraints.DefaultServiceProperties;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params.ECDomainParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params.ECKeyGenerationParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params.ECPrivateKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params.ECPublicKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.ECConstants;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.ECMultiplier;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.ECPoint;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.FixedPointCombMultiplier;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.WNafUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    private final String name;
    ECDomainParameters params;
    SecureRandom random;

    public ECKeyPairGenerator() {
        this("ECKeyGen");
    }

    protected ECKeyPairGenerator(String string) {
        this.name = string;
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.name, ConstraintUtils.bitsOfSecurityFor(this.params.getCurve()), eCKeyGenerationParameters.getDomainParameters(), CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        int n2 = n >>> 2;
        while (this.isOutOfRangeD(bigInteger = BigIntegers.createRandomBigInteger(n, this.random), bigInteger2) || WNafUtil.getNafWeight(bigInteger) < n2) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }

    protected boolean isOutOfRangeD(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(ONE) < 0 || bigInteger.compareTo(bigInteger2) >= 0;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

