/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.CryptoServicePurpose;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.digests.KeccakDigest;

public class SHA3Digest
extends KeccakDigest {
    private static int checkBitLength(int n) {
        switch (n) {
            case 224: 
            case 256: 
            case 384: 
            case 512: {
                return n;
            }
        }
        throw new IllegalArgumentException("'bitLength' " + n + " not supported for SHA-3");
    }

    public SHA3Digest() {
        this(256, CryptoServicePurpose.ANY);
    }

    public SHA3Digest(int n) {
        super(SHA3Digest.checkBitLength(n), CryptoServicePurpose.ANY);
    }

    public SHA3Digest(int n, CryptoServicePurpose cryptoServicePurpose) {
        super(SHA3Digest.checkBitLength(n), cryptoServicePurpose);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA3-" + this.fixedOutputLength;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        this.absorbBits(2, 2);
        return super.doFinal(byArray, n);
    }
}

