/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.FieldMasker;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.BeanFieldMaskerCache;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.JacksonBeanFieldInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.jackson.core.JsonParser;
import io.opentelemetry.testing.internal.jackson.databind.BeanDescription;
import io.opentelemetry.testing.internal.jackson.databind.BeanProperty;
import io.opentelemetry.testing.internal.jackson.databind.DeserializationConfig;
import io.opentelemetry.testing.internal.jackson.databind.DeserializationContext;
import io.opentelemetry.testing.internal.jackson.databind.JsonDeserializer;
import io.opentelemetry.testing.internal.jackson.databind.JsonMappingException;
import io.opentelemetry.testing.internal.jackson.databind.deser.BeanDeserializerModifier;
import io.opentelemetry.testing.internal.jackson.databind.deser.std.DelegatingDeserializer;
import java.io.IOException;

final class MaskingBeanDeserializerModifier
extends BeanDeserializerModifier {
    private static final long serialVersionUID = -2068102511617505526L;
    private final BeanFieldMaskerCache maskerCache;

    MaskingBeanDeserializerModifier(BeanFieldMaskerCache maskerCache) {
        this.maskerCache = maskerCache;
    }

    @Override
    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        return new MaskingJsonDeserializer(deserializer, beanDesc, null, this.maskerCache);
    }

    private static final class MaskingJsonDeserializer
    extends DelegatingDeserializer {
        private static final long serialVersionUID = -9079127442512906109L;
        private final JsonDeserializer<?> delegate;
        private final BeanDescription beanDesc;
        private final BeanFieldMaskerCache maskerCache;
        @Nullable
        private final BeanProperty beanProperty;
        private final FieldMasker mapper;

        MaskingJsonDeserializer(JsonDeserializer<?> delegate, BeanDescription beanDesc, @Nullable BeanProperty beanProperty, BeanFieldMaskerCache maskerCache) {
            super(delegate);
            this.delegate = delegate;
            this.beanDesc = beanDesc;
            this.beanProperty = beanProperty;
            this.maskerCache = maskerCache;
            this.mapper = beanProperty != null ? maskerCache.fieldMasker(new JacksonBeanFieldInfo(beanDesc, beanProperty)) : FieldMasker.noMask();
        }

        @Override
        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Class<?> mappedClass = this.mapper.mappedClass(this.beanDesc.getBeanClass());
            Object readValue = mappedClass != this.beanDesc.getBeanClass() ? p.readValueAs(mappedClass) : this.delegate.deserialize(p, ctxt);
            Object unmasked = this.mapper.unmask(readValue, this.beanDesc.getBeanClass());
            Preconditions.checkArgument(unmasked != null, "Mapper (%s) returned null for: (%s)", (Object)this.mapper, unmasked);
            return unmasked;
        }

        @Override
        protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> jsonDeserializer) {
            return new MaskingJsonDeserializer(jsonDeserializer, this.beanDesc, this.beanProperty, this.maskerCache);
        }

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty beanProperty) throws JsonMappingException {
            JsonDeserializer<?> contextual = super.createContextual(ctxt, beanProperty);
            return new MaskingJsonDeserializer(contextual, this.beanDesc, beanProperty, this.maskerCache);
        }
    }
}

