/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpObject;
import io.opentelemetry.testing.internal.armeria.common.Cookies;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.QueryParams;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.multipart.Multipart;
import io.opentelemetry.testing.internal.armeria.common.multipart.MultipartFile;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedRequestJsonSerializer;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedResponseJsonSerializer;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.jackson.databind.ObjectMapper;
import io.opentelemetry.testing.internal.jackson.databind.module.SimpleModule;
import io.opentelemetry.testing.internal.jackson.databind.ser.std.ToStringSerializer;
import java.io.File;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public final class AnnotatedServiceLogUtil {
    private static final Set<Class<?>> wellKnownTypes = ImmutableSet.of(HttpRequest.class, HttpResponse.class, AggregatedHttpObject.class, RequestContext.class, MultipartFile.class, File.class, new Class[]{Path.class, Multipart.class, QueryParams.class, Cookies.class, HttpHeaders.class});

    public static void customize(ObjectMapper objectMapper) {
        SimpleModule module = new SimpleModule("annotated-service-logging");
        AnnotatedServiceLogUtil.customizeWellKnownSerializers(module);
        module.addSerializer(new AnnotatedRequestJsonSerializer());
        module.addSerializer(new AnnotatedResponseJsonSerializer());
        objectMapper.registerModule(module);
    }

    static void customizeWellKnownSerializers(SimpleModule module) {
        for (Class<?> clazz : wellKnownTypes) {
            module.addSerializer(clazz, new ToStringSerializer(clazz));
        }
    }

    @Nullable
    static Object maybeUnwrapFuture(@Nullable Object param) {
        if (param == null) {
            return null;
        }
        if (param instanceof CompletableFuture) {
            CompletableFuture future = (CompletableFuture)param;
            if (!future.isDone() || future.isCompletedExceptionally()) {
                return null;
            }
            return future.join();
        }
        return param;
    }

    private AnnotatedServiceLogUtil() {
    }
}

