/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.internal.server.annotation.DefaultAnnotatedService;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.Route;
import io.opentelemetry.testing.internal.armeria.server.annotation.AnnotatedService;
import java.util.Objects;
import java.util.function.Function;

public final class AnnotatedServiceElement {
    private final Route route;
    private final DefaultAnnotatedService service;
    private final Function<? super HttpService, ? extends HttpService> decorator;

    AnnotatedServiceElement(Route route, DefaultAnnotatedService service, Function<? super HttpService, ? extends HttpService> decorator) {
        this.route = Objects.requireNonNull(route, "route");
        this.service = Objects.requireNonNull(service, "service");
        this.decorator = Objects.requireNonNull(decorator, "decorator");
    }

    public Route route() {
        return this.route;
    }

    public AnnotatedService service() {
        return this.service;
    }

    public Function<? super HttpService, ? extends HttpService> decorator() {
        return this.decorator;
    }

    public HttpService buildSafeDecoratedService(Function<? super HttpService, ? extends HttpService> localDecorator) {
        HttpService decoratedService = this.decorator.apply(this.service);
        decoratedService = decoratedService.decorate(localDecorator);
        return this.service.withExceptionHandler(decoratedService);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("route", this.route()).add("service", this.service()).add("decorator", this.decorator()).toString();
    }
}

