/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.util;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.common.util.MinifiedBouncyCastleProvider;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x500.AttributeTypeAndValue;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x500.RDN;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x500.X500Name;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x500.style.BCStyle;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x500.style.IETFUtils;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import io.opentelemetry.testing.internal.armeria.internal.shaded.caffeine.cache.Caffeine;
import io.opentelemetry.testing.internal.armeria.internal.shaded.caffeine.cache.LoadingCache;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufAllocator;
import io.opentelemetry.testing.internal.io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.opentelemetry.testing.internal.io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.InputStream;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateUtil {
    private static final Logger logger = LoggerFactory.getLogger(CertificateUtil.class);
    private static final LoadingCache<X509Certificate, String> hostnameCache = Caffeine.newBuilder().weakKeys().build(cert -> {
        try {
            String san = CertificateUtil.extractSubjectAlternativeName(cert);
            if (san != null) {
                return san;
            }
            String commonName = CertificateUtil.extractCommonName(cert);
            if (commonName != null) {
                return commonName;
            }
            logger.warn("No common name or subject alternative name found in certificate: {}", cert);
            return null;
        }
        catch (Exception e) {
            logger.warn("Failed to get the common name or subject alternative name name from a certificate: {}", cert, (Object)e);
            return null;
        }
    });

    @Nullable
    private static String extractCommonName(X509Certificate cert) throws CertificateEncodingException {
        X500Name x500Name = new JcaX509CertificateHolder(cert).getSubject();
        RDN[] cns = x500Name.getRDNs(BCStyle.CN);
        if (cns == null || cns.length == 0) {
            return null;
        }
        AttributeTypeAndValue cn = cns[0].getFirst();
        if (cn == null) {
            return null;
        }
        return IETFUtils.valueToString(cn.getValue());
    }

    @Nullable
    private static String extractSubjectAlternativeName(X509Certificate cert) {
        try {
            Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
            if (altNames == null) {
                return null;
            }
            for (List<?> altName : altNames) {
                Object o;
                Integer type = altName.size() >= 2 ? (Integer)altName.get(0) : null;
                if (type == null || type != 2 && type != 7 || !((o = altName.get(1)) instanceof String)) continue;
                return (String)o;
            }
            return null;
        }
        catch (CertificateParsingException ex) {
            logger.warn("Failed to parse subject alternative names from a certificate: {}", (Object)cert, (Object)ex);
            return null;
        }
    }

    @Nullable
    public static String getHostname(SSLSession session) {
        Certificate[] certs = session.getLocalCertificates();
        if (certs == null || certs.length == 0) {
            return null;
        }
        return CertificateUtil.getHostname(certs[0]);
    }

    @Nullable
    public static String getHostname(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            return null;
        }
        return hostnameCache.get((X509Certificate)certificate);
    }

    public static List<X509Certificate> toX509Certificates(File file) throws CertificateException {
        Objects.requireNonNull(file, "file");
        return ImmutableList.copyOf(SslContextProtectedAccessHack.toX509CertificateList(file));
    }

    public static List<X509Certificate> toX509Certificates(InputStream in) throws CertificateException {
        Objects.requireNonNull(in, "in");
        return ImmutableList.copyOf(SslContextProtectedAccessHack.toX509CertificateList(in));
    }

    public static PrivateKey toPrivateKey(File file, @Nullable String keyPassword) throws KeyException {
        Objects.requireNonNull(file, "file");
        return MinifiedBouncyCastleProvider.call(() -> {
            try {
                return SslContextProtectedAccessHack.privateKey(file, keyPassword);
            }
            catch (KeyException e) {
                return (PrivateKey)Exceptions.throwUnsafely(e);
            }
        });
    }

    public static PrivateKey toPrivateKey(InputStream keyInputStream, @Nullable String keyPassword) throws KeyException {
        Objects.requireNonNull(keyInputStream, "keyInputStream");
        return MinifiedBouncyCastleProvider.call(() -> {
            try {
                return SslContextProtectedAccessHack.privateKey(keyInputStream, keyPassword);
            }
            catch (KeyException e) {
                return (PrivateKey)Exceptions.throwUnsafely(e);
            }
        });
    }

    private CertificateUtil() {
    }

    private static final class SslContextProtectedAccessHack
    extends SslContext {
        private SslContextProtectedAccessHack() {
        }

        static X509Certificate[] toX509CertificateList(File file) throws CertificateException {
            return SslContext.toX509Certificates(file);
        }

        static X509Certificate[] toX509CertificateList(InputStream in) throws CertificateException {
            return SslContext.toX509Certificates(in);
        }

        static PrivateKey privateKey(File file, @Nullable String keyPassword) throws KeyException {
            try {
                return SslContext.toPrivateKey(file, keyPassword);
            }
            catch (Exception e) {
                if (e instanceof KeyException) {
                    throw (KeyException)e;
                }
                throw new KeyException("Fail to read a private key file: " + file.getName(), e);
            }
        }

        static PrivateKey privateKey(InputStream keyInputStream, @Nullable String keyPassword) throws KeyException {
            try {
                return SslContext.toPrivateKey(keyInputStream, keyPassword);
            }
            catch (Exception e) {
                if (e instanceof KeyException) {
                    throw (KeyException)e;
                }
                throw new KeyException("Fail to parse a private key", e);
            }
        }

        @Override
        public boolean isClient() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> cipherSuites() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SSLEngine newEngine(ByteBufAllocator alloc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SSLEngine newEngine(ByteBufAllocator alloc, String peerHost, int peerPort) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SSLSessionContext sessionContext() {
            throw new UnsupportedOperationException();
        }
    }
}

