/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.encoding;

import io.opentelemetry.testing.internal.armeria.common.encoding.StreamDecoderFactory;
import io.opentelemetry.testing.internal.armeria.internal.common.encoding.SnappyFramedOutputStream;
import io.opentelemetry.testing.internal.armeria.internal.common.encoding.StreamEncoderFactory;
import io.opentelemetry.testing.internal.brotli4j.encoder.BrotliOutputStream;
import io.opentelemetry.testing.internal.brotli4j.encoder.Encoder;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufOutputStream;
import io.opentelemetry.testing.internal.io.netty.handler.codec.compression.Brotli;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public enum StreamEncoderFactories implements StreamEncoderFactory
{
    BROTLI{

        @Override
        public String encodingHeaderValue() {
            return StreamDecoderFactory.brotli().encodingHeaderValue();
        }

        @Override
        public OutputStream newEncoder(ByteBufOutputStream os) {
            try {
                return new BrotliOutputStream(os, BROTLI_PARAMETERS);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error writing brotli header. This should not happen with byte arrays.", e);
            }
        }
    }
    ,
    GZIP{

        @Override
        public String encodingHeaderValue() {
            return StreamDecoderFactory.gzip().encodingHeaderValue();
        }

        @Override
        public OutputStream newEncoder(ByteBufOutputStream os) {
            try {
                return new GZIPOutputStream((OutputStream)os, true);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error writing gzip header. This should not happen with byte arrays.", e);
            }
        }
    }
    ,
    DEFLATE{

        @Override
        public String encodingHeaderValue() {
            return StreamDecoderFactory.deflate().encodingHeaderValue();
        }

        @Override
        public OutputStream newEncoder(ByteBufOutputStream os) {
            return new DeflaterOutputStream((OutputStream)os, true);
        }
    }
    ,
    SNAPPY{

        @Override
        public String encodingHeaderValue() {
            return StreamDecoderFactory.snappy().encodingHeaderValue();
        }

        @Override
        public OutputStream newEncoder(ByteBufOutputStream os) {
            return new SnappyFramedOutputStream(os.buffer());
        }
    };

    private static final Encoder.Parameters BROTLI_PARAMETERS;

    static {
        Brotli.isAvailable();
        BROTLI_PARAMETERS = new Encoder.Parameters().setQuality(4);
    }
}

