/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.client.dns;

import io.opentelemetry.testing.internal.armeria.client.DnsCache;
import io.opentelemetry.testing.internal.armeria.client.DnsTimeoutException;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.CachingDnsResolver;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DelegatingDnsResolver;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DnsQuestionContext;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DnsResolver;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.HostsFileDnsResolver;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.SearchDomainDnsResolver;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsQuestion;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsRecord;
import io.opentelemetry.testing.internal.io.netty.resolver.HostsFileEntriesResolver;
import io.opentelemetry.testing.internal.io.netty.resolver.ResolvedAddressTypes;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.DnsNameResolver;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class DefaultDnsResolver
implements SafeCloseable {
    private final DnsResolver delegate;
    private final DnsCache dnsCache;
    private final EventExecutor executor;
    private final long queryTimeoutMillis;

    public static DefaultDnsResolver of(DnsNameResolver delegate, DnsCache dnsCache, EventExecutor eventLoop, List<String> searchDomains, int ndots, long queryTimeoutMillis, HostsFileEntriesResolver hostsFileEntriesResolver) {
        Objects.requireNonNull(delegate, "delegate");
        Objects.requireNonNull(dnsCache, "dnsCache");
        Objects.requireNonNull(eventLoop, "eventLoop");
        Objects.requireNonNull(searchDomains, "searchDomains");
        Objects.requireNonNull(hostsFileEntriesResolver, "hostsFileEntriesResolver");
        DnsResolver resolver = new DelegatingDnsResolver(delegate, eventLoop);
        resolver = new CachingDnsResolver(resolver, dnsCache);
        if (!searchDomains.isEmpty()) {
            resolver = new SearchDomainDnsResolver(resolver, searchDomains, ndots);
        }
        ResolvedAddressTypes resolvedAddressTypes = delegate.resolvedAddressTypes();
        resolver = new HostsFileDnsResolver(resolver, hostsFileEntriesResolver, resolvedAddressTypes);
        return new DefaultDnsResolver(resolver, dnsCache, eventLoop, queryTimeoutMillis);
    }

    public DefaultDnsResolver(DnsResolver delegate, DnsCache dnsCache, EventExecutor executor, long queryTimeoutMillis) {
        this.delegate = delegate;
        this.dnsCache = dnsCache;
        this.executor = executor;
        this.queryTimeoutMillis = queryTimeoutMillis;
    }

    public CompletableFuture<List<DnsRecord>> resolve(List<? extends DnsQuestion> questions, String logPrefix) {
        assert (!questions.isEmpty());
        DnsQuestionContext ctx = new DnsQuestionContext(this.executor, this.queryTimeoutMillis);
        if (questions.size() == 1) {
            return this.resolveOne(ctx, questions.get(0));
        }
        return this.resolveAll(ctx, questions, logPrefix);
    }

    private CompletableFuture<List<DnsRecord>> resolveOne(DnsQuestionContext ctx, DnsQuestion question) {
        assert (this.executor.inEventLoop());
        CompletableFuture<List<DnsRecord>> future = this.delegate.resolve(ctx, question);
        ctx.whenCancelled().handle((unused0, unused1) -> {
            if (!future.isDone()) {
                future.completeExceptionally(new DnsTimeoutException(question + " is timed out after " + ctx.queryTimeoutMillis() + " milliseconds."));
            }
            return null;
        });
        future.handle((unused0, unused1) -> {
            ctx.setComplete();
            return null;
        });
        return future;
    }

    CompletableFuture<List<DnsRecord>> resolveAll(DnsQuestionContext ctx, List<? extends DnsQuestion> questions, String logPrefix) {
        assert (this.executor.inEventLoop());
        CompletableFuture<List<DnsRecord>> future = new CompletableFuture<List<DnsRecord>>();
        Object[] results = new Object[questions.size()];
        for (int i = 0; i < questions.size(); ++i) {
            int order = i;
            this.delegate.resolve(ctx, questions.get(i)).handle((records, cause) -> {
                assert (this.executor.inEventLoop());
                DefaultDnsResolver.maybeCompletePreferredRecords(ctx, future, questions, results, order, records, cause);
                return null;
            });
        }
        ctx.whenCancelled().handle((unused0, unused1) -> {
            if (!future.isDone()) {
                assert (this.executor.inEventLoop());
                for (Object result : results) {
                    if (!(result instanceof List)) continue;
                    future.complete((List)result);
                    return null;
                }
                future.completeExceptionally(new DnsTimeoutException('[' + logPrefix + "] " + questions + " is timed out after " + ctx.queryTimeoutMillis() + " milliseconds."));
            }
            return null;
        });
        return future;
    }

    static void maybeCompletePreferredRecords(DnsQuestionContext ctx, CompletableFuture<List<DnsRecord>> future, List<? extends DnsQuestion> questions, Object[] results, int order, @Nullable List<DnsRecord> records, @Nullable Throwable cause) {
        if (future.isDone()) {
            return;
        }
        results[order] = cause != null ? Exceptions.peel(cause) : records;
        for (Object result : results) {
            if (result == null) {
                return;
            }
            if (result instanceof Throwable) continue;
            assert (result instanceof List);
            future.complete(Collections.unmodifiableList((List)result));
            ctx.setComplete();
            return;
        }
        UnknownHostException unknownHostException = new UnknownHostException("Failed to resolve: " + questions);
        for (Object result : results) {
            assert (result instanceof Throwable);
            unknownHostException.addSuppressed((Throwable)result);
        }
        future.completeExceptionally(unknownHostException);
        ctx.setComplete();
    }

    public DnsCache dnsCache() {
        return this.dnsCache;
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

