/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.util;

import io.opentelemetry.testing.internal.armeria.common.util.Inet4AddressBlock;
import io.opentelemetry.testing.internal.armeria.common.util.Inet6AddressBlock;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Splitter;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.opentelemetry.testing.internal.io.netty.util.NetUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public final class InetAddressPredicates {
    private static final Splitter dotSplitter = Splitter.on('.').limit(4);
    private static final Map<Integer, Integer> ipDecimalToMaskBits = new ImmutableMap.Builder<Integer, Integer>().put(255, 8).put(254, 7).put(252, 6).put(248, 5).put(240, 4).put(224, 3).put(192, 2).put(128, 1).put(0, 0).build();

    public static Predicate<InetAddress> ofExact(InetAddress address) {
        Objects.requireNonNull(address, "address");
        if (address instanceof Inet4Address) {
            return InetAddressPredicates.ofCidr(address, 32);
        }
        if (address instanceof Inet6Address) {
            return InetAddressPredicates.ofCidr(address, 128);
        }
        throw new IllegalArgumentException("Invalid InetAddress type: " + address.getClass().getName());
    }

    public static Predicate<InetAddress> ofExact(String address) {
        Objects.requireNonNull(address, "address");
        try {
            InetAddress inetAddress = InetAddress.getByName(address);
            return InetAddressPredicates.ofExact(inetAddress);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid address: " + address, e);
        }
    }

    public static Predicate<InetAddress> ofCidr(InetAddress baseAddress, int maskBits) {
        Objects.requireNonNull(baseAddress, "baseAddress");
        Preconditions.checkArgument(maskBits >= 0, "maskBits: %s (expected: >= 0)", maskBits);
        return InetAddressPredicates.ofCidr(baseAddress, maskBits, maskBits);
    }

    public static Predicate<InetAddress> ofCidr(InetAddress baseAddress, String subnetMask) {
        Objects.requireNonNull(baseAddress, "baseAddress");
        Objects.requireNonNull(subnetMask, "subnetMask");
        Preconditions.checkArgument(NetUtil.isValidIpV4Address(subnetMask), "subnetMask: %s (expected: an IPv4 address string)", (Object)subnetMask);
        int maskBits = InetAddressPredicates.toMaskBits(subnetMask);
        return InetAddressPredicates.ofCidr(baseAddress, maskBits, maskBits + 96);
    }

    public static Predicate<InetAddress> ofCidr(String cidr) {
        int maskBits;
        InetAddress baseAddress;
        Objects.requireNonNull(cidr, "cidr");
        int delim = cidr.indexOf(47);
        try {
            if (delim < 0) {
                baseAddress = InetAddress.getByName(cidr);
                maskBits = baseAddress instanceof Inet4Address ? 32 : 128;
            } else {
                baseAddress = InetAddress.getByName(cidr.substring(0, delim));
                String subnetMask = cidr.substring(delim + 1);
                Preconditions.checkArgument(!subnetMask.isEmpty(), "Invalid CIDR notation: %s", (Object)cidr);
                if (NetUtil.isValidIpV4Address(subnetMask)) {
                    int maskBits2 = InetAddressPredicates.toMaskBits(subnetMask);
                    return InetAddressPredicates.ofCidr(baseAddress, maskBits2, maskBits2 + 96);
                }
                maskBits = Integer.parseInt(subnetMask);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid CIDR notation: " + cidr, e);
        }
        return InetAddressPredicates.ofCidr(baseAddress, maskBits, maskBits);
    }

    private static Predicate<InetAddress> ofCidr(InetAddress baseAddress, int inet4MaskBits, int inet6MaskBits) {
        if (baseAddress instanceof Inet4Address) {
            return new Inet4AddressBlock((Inet4Address)baseAddress, inet4MaskBits);
        }
        if (baseAddress instanceof Inet6Address) {
            byte[] bytes = Inet4AddressBlock.ipv6ToIpv4Address((Inet6Address)baseAddress);
            if (bytes == null) {
                return new Inet6AddressBlock((Inet6Address)baseAddress, inet6MaskBits);
            }
            try {
                Inet4Address inet4Address = (Inet4Address)InetAddress.getByAddress(bytes);
                return new Inet4AddressBlock(inet4Address, inet6MaskBits - 96);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid address: " + baseAddress.getHostAddress(), e);
            }
        }
        throw new IllegalArgumentException("Unknown baseAddress type: " + baseAddress.getClass().getName() + " (expected: " + Inet4Address.class.getSimpleName() + " or " + Inet6Address.class.getSimpleName() + ')');
    }

    static int toMaskBits(String subnetMask) {
        int maskBits = 0;
        boolean expectZero = false;
        for (String ipValue : dotSplitter.split(subnetMask)) {
            int num = Integer.parseInt(ipValue);
            if (expectZero && num != 0) {
                throw new IllegalArgumentException("Invalid subnet mask address: " + subnetMask);
            }
            int bits = ipDecimalToMaskBits.getOrDefault(num, -1);
            if (bits < 0) {
                throw new IllegalArgumentException("Invalid subnet mask address: " + subnetMask);
            }
            maskBits += bits;
            if (bits == 8 || expectZero) continue;
            expectZero = true;
        }
        return maskBits;
    }

    private InetAddressPredicates() {
    }
}

