/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.outlier;

import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.outlier.DisabledOutlierDetection;
import io.opentelemetry.testing.internal.armeria.common.outlier.OutlierDetectionBuilder;
import io.opentelemetry.testing.internal.armeria.common.outlier.OutlierDetector;
import io.opentelemetry.testing.internal.armeria.common.outlier.OutlierRule;
import java.util.Objects;

@UnstableApi
public interface OutlierDetection {
    public static OutlierDetection of(OutlierRule rule) {
        Objects.requireNonNull(rule, "rule");
        if (rule == OutlierRule.of()) {
            return OutlierDetection.of();
        }
        return OutlierDetection.builder(rule).build();
    }

    public static OutlierDetection of() {
        return OutlierDetectionBuilder.DEFAULT_DETECTION;
    }

    public static OutlierDetectionBuilder builder(OutlierRule rule) {
        Objects.requireNonNull(rule, "rule");
        return new OutlierDetectionBuilder(rule);
    }

    public static OutlierDetection disabled() {
        return DisabledOutlierDetection.INSTANCE;
    }

    public OutlierRule rule();

    public OutlierDetector newDetector();
}

