/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.logging;

import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.logging.AbstractLogFormatterBuilder;
import io.opentelemetry.testing.internal.armeria.common.logging.HeadersSanitizer;
import io.opentelemetry.testing.internal.armeria.common.logging.JsonLogFormatter;
import io.opentelemetry.testing.internal.armeria.common.logging.LogFormatter;
import io.opentelemetry.testing.internal.armeria.internal.common.JacksonUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedServiceLogUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.jackson.databind.JsonNode;
import io.opentelemetry.testing.internal.jackson.databind.ObjectMapper;
import io.opentelemetry.testing.internal.jackson.databind.SerializationFeature;
import java.util.Objects;
import java.util.function.BiFunction;

@UnstableApi
public final class JsonLogFormatterBuilder
extends AbstractLogFormatterBuilder<JsonLogFormatterBuilder, JsonNode> {
    private ObjectMapper objectMapper = JacksonUtil.newDefaultObjectMapper();

    JsonLogFormatterBuilder() {
        this.objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        AnnotatedServiceLogUtil.customize(this.objectMapper);
    }

    public JsonLogFormatterBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
        return this;
    }

    public LogFormatter build() {
        ObjectMapper objectMapper = this.objectMapper;
        HeadersSanitizer<JsonNode> defaultHeadersSanitizer = JsonLogFormatterBuilder.defaultHeadersSanitizer(objectMapper);
        BiFunction defaultContentSanitizer = JsonLogFormatterBuilder.defaultSanitizer(objectMapper);
        return new JsonLogFormatter(MoreObjects.firstNonNull(this.requestHeadersSanitizer(), HeadersSanitizer.ofJson()), MoreObjects.firstNonNull(this.responseHeadersSanitizer(), HeadersSanitizer.ofJson()), MoreObjects.firstNonNull(this.requestTrailersSanitizer(), defaultHeadersSanitizer), MoreObjects.firstNonNull(this.responseTrailersSanitizer(), defaultHeadersSanitizer), MoreObjects.firstNonNull(this.requestContentSanitizer(), defaultContentSanitizer), MoreObjects.firstNonNull(this.responseContentSanitizer(), defaultContentSanitizer), objectMapper);
    }

    private static <T> BiFunction<? super RequestContext, T, JsonNode> defaultSanitizer(ObjectMapper objectMapper) {
        return (requestContext, obj) -> objectMapper.valueToTree(obj);
    }

    private static HeadersSanitizer<JsonNode> defaultHeadersSanitizer(ObjectMapper objectMapper) {
        return (requestContext, obj) -> objectMapper.valueToTree(obj);
    }
}

