/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.logging;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.logging.ContentPreviewer;
import io.opentelemetry.testing.internal.armeria.common.logging.ContentPreviewerFactory;
import io.opentelemetry.testing.internal.armeria.common.logging.PreviewSpec;
import io.opentelemetry.testing.internal.armeria.common.logging.ProducerBasedContentPreviewer;
import io.opentelemetry.testing.internal.armeria.common.logging.TextContentPreviewer;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.BiFunction;

final class DefaultContentPreviewFactory
implements ContentPreviewerFactory {
    private static final List<String> textSubTypes = ImmutableList.of("json", "xml");
    private static final List<String> textSubTypeSuffixes = ImmutableList.of("+json", "+xml");
    private final int maxLength;
    private final List<PreviewSpec> previewSpecs;
    private final Charset defaultCharset;

    DefaultContentPreviewFactory(List<PreviewSpec> previewSpecs, int maxLength, Charset defaultCharset) {
        this.maxLength = maxLength;
        this.previewSpecs = previewSpecs;
        this.defaultCharset = defaultCharset;
    }

    @Override
    public ContentPreviewer requestContentPreviewer(RequestContext ctx, RequestHeaders headers) {
        return this.contentPreviewer(ctx, headers);
    }

    @Override
    public ContentPreviewer responseContentPreviewer(RequestContext ctx, ResponseHeaders resHeaders) {
        return this.contentPreviewer(ctx, resHeaders);
    }

    private ContentPreviewer contentPreviewer(RequestContext ctx, HttpHeaders headers) {
        block11: {
            block12: {
                for (PreviewSpec previewSpec : this.previewSpecs) {
                    if (!previewSpec.predicate().test(ctx, headers)) continue;
                    switch (previewSpec.mode()) {
                        case TEXT: {
                            Charset charset = this.charset(headers);
                            return new TextContentPreviewer(this.maxLength, charset);
                        }
                        case BINARY: {
                            BiFunction<? super HttpHeaders, ? super ByteBuf, String> producer = previewSpec.producer();
                            assert (producer != null);
                            return new ProducerBasedContentPreviewer(this.maxLength, headers, producer);
                        }
                        case DISABLED: {
                            return ContentPreviewer.disabled();
                        }
                    }
                }
                MediaType contentType = headers.contentType();
                if (contentType == null) break block11;
                Charset charset = contentType.charset();
                if (charset != null) {
                    return new TextContentPreviewer(this.maxLength, charset);
                }
                if ("text".equals(contentType.type()) || textSubTypes.contains(contentType.subtype())) break block12;
                if (!textSubTypeSuffixes.stream().anyMatch(contentType.subtype()::endsWith) && !contentType.is(MediaType.FORM_DATA)) break block11;
            }
            return new TextContentPreviewer(this.maxLength, this.defaultCharset);
        }
        return ContentPreviewer.disabled();
    }

    private Charset charset(HttpHeaders headers) {
        MediaType contentType = headers.contentType();
        if (contentType != null) {
            return contentType.charset(this.defaultCharset);
        }
        return this.defaultCharset;
    }
}

