/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.loadbalancer;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.SimpleLoadBalancer;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.Weighted;
import io.opentelemetry.testing.internal.armeria.internal.common.loadbalancer.WeightedObject;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterables;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Streams;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToIntFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WeightedRoundRobinLoadBalancer<T>
implements SimpleLoadBalancer<T> {
    private static final Logger logger = LoggerFactory.getLogger(WeightedRoundRobinLoadBalancer.class);
    private final AtomicInteger sequence = new AtomicInteger();
    private final CandidatesAndWeights<T> candidatesAndWeights;

    WeightedRoundRobinLoadBalancer(Iterable<T> candidates, @Nullable ToIntFunction<T> weightFunction) {
        this.candidatesAndWeights = new CandidatesAndWeights<T>(candidates, weightFunction);
    }

    @Override
    @Nullable
    public T pick() {
        return this.candidatesAndWeights.select(this.sequence.getAndIncrement());
    }

    private static final class CandidatesAndWeights<T> {
        private final List<Weighted> candidates;
        private final boolean weighted;
        private final long totalWeight;
        private final List<CandidatesGroupByWeight> accumulatedGroups;

        CandidatesAndWeights(Iterable<T> candidates0, @Nullable ToIntFunction<T> weightFunction) {
            this.candidates = Streams.stream(candidates0).map(e -> {
                if (weightFunction == null) {
                    return (Weighted)e;
                }
                return new WeightedObject<Object>(e, weightFunction.applyAsInt(e));
            }).filter(e -> e.weight() > 0).sorted(Comparator.comparing(Weighted::weight)).collect(ImmutableList.toImmutableList());
            long numCandidates = this.candidates.size();
            if (numCandidates == 0L && !Iterables.isEmpty(candidates0)) {
                logger.warn("No valid candidate with weight > 0. candidates: {}", this.candidates);
            }
            int minWeight = Integer.MAX_VALUE;
            int maxWeight = Integer.MIN_VALUE;
            int numberDistinctWeight = 0;
            int oldWeight = -1;
            for (Weighted candidate : this.candidates) {
                int weight = candidate.weight();
                minWeight = Math.min(minWeight, weight);
                maxWeight = Math.max(maxWeight, weight);
                numberDistinctWeight += weight == oldWeight ? 0 : 1;
                oldWeight = weight;
            }
            long totalWeight = 0L;
            ImmutableList.Builder accumulatedGroupsBuilder = ImmutableList.builderWithExpectedSize(numberDistinctWeight);
            CandidatesGroupByWeight currentGroup = null;
            long rest = numCandidates;
            for (Weighted candidate : this.candidates) {
                if (currentGroup == null || currentGroup.weight != candidate.weight()) {
                    currentGroup = new CandidatesGroupByWeight(numCandidates - rest, candidate.weight(), totalWeight += currentGroup == null ? (long)candidate.weight() * rest : (long)(candidate.weight() - currentGroup.weight) * rest);
                    accumulatedGroupsBuilder.add(currentGroup);
                }
                --rest;
            }
            this.accumulatedGroups = accumulatedGroupsBuilder.build();
            this.totalWeight = totalWeight;
            this.weighted = minWeight != maxWeight;
        }

        @Nullable
        T select(int currentSequence) {
            Weighted selected = this.select0(currentSequence);
            if (selected instanceof WeightedObject) {
                return ((WeightedObject)selected).get();
            }
            return (T)selected;
        }

        @Nullable
        Weighted select0(int currentSequence) {
            if (this.candidates.isEmpty()) {
                return null;
            }
            if (this.weighted) {
                int mid;
                long numberCandidates = this.candidates.size();
                long mod = Math.abs((long)currentSequence % this.totalWeight);
                if (mod < this.accumulatedGroups.get((int)0).accumulatedWeight) {
                    return this.candidates.get((int)(mod % numberCandidates));
                }
                int left = 0;
                int right = this.accumulatedGroups.size() - 1;
                while (left < right && (mid = left + (right - left >> 1)) != left) {
                    if (this.accumulatedGroups.get((int)mid).accumulatedWeight <= mod) {
                        left = mid;
                        continue;
                    }
                    right = mid;
                }
                long indexInPart = mod - this.accumulatedGroups.get((int)left).accumulatedWeight;
                long startIndex = this.accumulatedGroups.get((int)(left + 1)).startIndex;
                return this.candidates.get((int)(startIndex + indexInPart % (numberCandidates - startIndex)));
            }
            return this.candidates.get(Math.abs(currentSequence % this.candidates.size()));
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("candidates", this.candidates).add("weighted", this.weighted).add("totalWeight", this.totalWeight).add("accumulatedGroups", this.accumulatedGroups).toString();
        }
    }

    private static final class CandidatesGroupByWeight {
        final long startIndex;
        final int weight;
        final long accumulatedWeight;

        CandidatesGroupByWeight(long startIndex, int weight, long accumulatedWeight) {
            this.startIndex = startIndex;
            this.weight = weight;
            this.accumulatedWeight = accumulatedWeight;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("startIndex", this.startIndex).add("weight", this.weight).add("accumulatedWeight", this.accumulatedWeight).toString();
        }
    }
}

