/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.loadbalancer;

import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.AggregationWeightTransition;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.LinearWeightTransition;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;

@FunctionalInterface
@UnstableApi
public interface WeightTransition<T> {
    public static <T> WeightTransition<T> linear() {
        return LinearWeightTransition.INSTANCE;
    }

    public static <T> WeightTransition<T> aggression(double aggression, double minWeightPercent) {
        Preconditions.checkArgument(aggression > 0.0, "aggression: %s (expected: > 0.0)", (Object)aggression);
        Preconditions.checkArgument(minWeightPercent >= 0.0 && minWeightPercent <= 1.0, "minWeightPercent: %s (expected: >= 0.0, <= 1.0)", (Object)minWeightPercent);
        return new AggregationWeightTransition(aggression, minWeightPercent);
    }

    public int compute(T var1, int var2, int var3, int var4);
}

