/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.client.ResponseTimeoutMode;
import io.opentelemetry.testing.internal.armeria.common.ExceptionSampler;
import io.opentelemetry.testing.internal.armeria.common.FlagsProvider;
import io.opentelemetry.testing.internal.armeria.common.FlagsUtil;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.RequestContextStorageProvider;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.InetAddressPredicates;
import io.opentelemetry.testing.internal.armeria.common.util.Sampler;
import io.opentelemetry.testing.internal.armeria.common.util.TlsEngineType;
import io.opentelemetry.testing.internal.armeria.common.util.TransportType;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Ascii;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Splitter;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Sets;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Streams;
import io.opentelemetry.testing.internal.armeria.server.MultipartRemovalStrategy;
import io.opentelemetry.testing.internal.armeria.server.TransientServiceOption;
import java.net.InetAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SystemPropertyFlagsProvider
implements FlagsProvider {
    static final SystemPropertyFlagsProvider INSTANCE = new SystemPropertyFlagsProvider();
    private static final Logger logger = LoggerFactory.getLogger(SystemPropertyFlagsProvider.class);
    private static final String PREFIX = "io.opentelemetry.testing.internal.armeria.";
    private static final Splitter CSV_SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();

    private SystemPropertyFlagsProvider() {
    }

    @Override
    public int priority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String name() {
        return "sysprops";
    }

    @Override
    @Nullable
    public Sampler<Class<? extends Throwable>> verboseExceptionSampler() {
        String spec = SystemPropertyFlagsProvider.getNormalized("verboseExceptions");
        if (spec == null) {
            return null;
        }
        try {
            Sampler.of(spec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid sampler spec: " + spec, e);
        }
        return new ExceptionSampler(spec);
    }

    @Override
    @Nullable
    public Boolean verboseSocketExceptions() {
        return SystemPropertyFlagsProvider.getBoolean("verboseSocketExceptions");
    }

    @Override
    @Nullable
    public Boolean verboseResponses() {
        return SystemPropertyFlagsProvider.getBoolean("verboseResponses");
    }

    @Override
    @Nullable
    public RequestContextStorageProvider requestContextStorageProvider() {
        String providerFqcn = System.getProperty("io.opentelemetry.testing.internal.armeria.requestContextStorageProvider");
        if (providerFqcn == null) {
            return null;
        }
        List<RequestContextStorageProvider> providers = FlagsUtil.getRequestContextStorageProviders();
        if (providers.isEmpty()) {
            throw new IllegalArgumentException(providerFqcn + " is specified, but no " + RequestContextStorageProvider.class.getSimpleName() + " is found");
        }
        List matchedCandidates = providers.stream().filter(provider -> provider.getClass().getName().equals(providerFqcn)).collect(ImmutableList.toImmutableList());
        if (matchedCandidates.isEmpty()) {
            throw new IllegalArgumentException(providerFqcn + " does not match any " + RequestContextStorageProvider.class.getSimpleName() + ". providers: " + providers);
        }
        if (matchedCandidates.size() > 1) {
            throw new IllegalArgumentException(providerFqcn + " matches more than one " + RequestContextStorageProvider.class.getSimpleName() + ". providers: " + providers);
        }
        return (RequestContextStorageProvider)matchedCandidates.get(0);
    }

    @Override
    @Nullable
    public Boolean warnNettyVersions() {
        return SystemPropertyFlagsProvider.getBoolean("warnNettyVersions");
    }

    @Override
    @Nullable
    public TransportType transportType() {
        String strTransportType = SystemPropertyFlagsProvider.getNormalized("transportType");
        if (strTransportType == null) {
            return null;
        }
        switch (strTransportType) {
            case "nio": {
                return TransportType.NIO;
            }
            case "epoll": {
                return TransportType.EPOLL;
            }
            case "io_uring": {
                return TransportType.IO_URING;
            }
        }
        throw new IllegalArgumentException(String.format("%s isn't TransportType", strTransportType));
    }

    @Override
    @Nullable
    public Boolean useOpenSsl() {
        return SystemPropertyFlagsProvider.getBoolean("useOpenSsl");
    }

    @Override
    @Nullable
    public TlsEngineType tlsEngineType() {
        String strTlsEngineType = SystemPropertyFlagsProvider.getNormalized("tlsEngineType");
        if (strTlsEngineType == null) {
            return null;
        }
        switch (strTlsEngineType) {
            case "jdk": {
                return TlsEngineType.JDK;
            }
            case "openssl": {
                return TlsEngineType.OPENSSL;
            }
        }
        throw new IllegalArgumentException(String.format("%s isn't one of 'jdk' or 'openssl'", strTlsEngineType));
    }

    @Override
    @Nullable
    public Boolean dumpOpenSslInfo() {
        return SystemPropertyFlagsProvider.getBoolean("dumpOpenSslInfo");
    }

    @Override
    @Nullable
    public Integer maxNumConnections() {
        return SystemPropertyFlagsProvider.getInt("maxNumConnections");
    }

    @Override
    @Nullable
    public Integer numCommonWorkers(TransportType transportType) {
        return SystemPropertyFlagsProvider.getInt("numCommonWorkers");
    }

    @Override
    @Nullable
    public Integer numCommonBlockingTaskThreads() {
        return SystemPropertyFlagsProvider.getInt("numCommonBlockingTaskThreads");
    }

    @Override
    @Nullable
    public Long defaultMaxRequestLength() {
        return SystemPropertyFlagsProvider.getLong("defaultMaxRequestLength");
    }

    @Override
    @Nullable
    public Long defaultMaxResponseLength() {
        return SystemPropertyFlagsProvider.getLong("defaultMaxResponseLength");
    }

    @Override
    @Nullable
    public Long defaultRequestTimeoutMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultRequestTimeoutMillis");
    }

    @Override
    @Nullable
    public Long defaultResponseTimeoutMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultResponseTimeoutMillis");
    }

    @Override
    @Nullable
    public Long defaultConnectTimeoutMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultConnectTimeoutMillis");
    }

    @Override
    @Nullable
    public Long defaultWriteTimeoutMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultWriteTimeoutMillis");
    }

    @Override
    @Nullable
    public Long defaultServerIdleTimeoutMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultServerIdleTimeoutMillis");
    }

    @Override
    @Nullable
    public Long defaultClientIdleTimeoutMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultClientIdleTimeoutMillis");
    }

    @Override
    @Nullable
    public Integer defaultHttp1MaxInitialLineLength() {
        return SystemPropertyFlagsProvider.getInt("defaultHttp1MaxInitialLineLength");
    }

    @Override
    @Nullable
    public Integer defaultHttp1MaxHeaderSize() {
        return SystemPropertyFlagsProvider.getInt("defaultHttp1MaxHeaderSize");
    }

    @Override
    @Nullable
    public Integer defaultHttp1MaxChunkSize() {
        return SystemPropertyFlagsProvider.getInt("defaultHttp1MaxChunkSize");
    }

    @Override
    @Nullable
    public Boolean defaultUseHttp2Preface() {
        return SystemPropertyFlagsProvider.getBoolean("defaultUseHttp2Preface");
    }

    @Override
    @Nullable
    public Boolean defaultPreferHttp1() {
        Boolean defaultPreferHttp1 = SystemPropertyFlagsProvider.getBoolean("defaultPreferHttp1");
        if (defaultPreferHttp1 != null) {
            return defaultPreferHttp1;
        }
        return SystemPropertyFlagsProvider.getBoolean("preferHttp1");
    }

    @Override
    @Nullable
    public Boolean defaultUseHttp2WithoutAlpn() {
        return SystemPropertyFlagsProvider.getBoolean("defaultUseHttp2WithoutAlpn");
    }

    @Override
    @Nullable
    public Boolean defaultUseHttp1Pipelining() {
        return SystemPropertyFlagsProvider.getBoolean("defaultUseHttp1Pipelining");
    }

    @Override
    @Nullable
    public Long defaultPingIntervalMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultPingIntervalMillis");
    }

    @Override
    @Nullable
    public Integer defaultMaxServerNumRequestsPerConnection() {
        return SystemPropertyFlagsProvider.getInt("defaultMaxServerNumRequestsPerConnection");
    }

    @Override
    @Nullable
    public Integer defaultMaxClientNumRequestsPerConnection() {
        return SystemPropertyFlagsProvider.getInt("defaultMaxClientNumRequestsPerConnection");
    }

    @Override
    @Nullable
    public Long defaultMaxServerConnectionAgeMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultMaxServerConnectionAgeMillis");
    }

    @Override
    @Nullable
    public Long defaultMaxClientConnectionAgeMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultMaxClientConnectionAgeMillis");
    }

    @Override
    @Nullable
    public Long defaultServerConnectionDrainDurationMicros() {
        return SystemPropertyFlagsProvider.getLong("defaultServerConnectionDrainDurationMicros");
    }

    @Override
    @Nullable
    public Long defaultClientHttp2GracefulShutdownTimeoutMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultClientHttp2GracefulShutdownTimeoutMillis");
    }

    @Override
    @Nullable
    public Integer defaultHttp2InitialConnectionWindowSize() {
        return SystemPropertyFlagsProvider.getInt("defaultHttp2InitialConnectionWindowSize");
    }

    @Override
    @Nullable
    public Integer defaultHttp2InitialStreamWindowSize() {
        return SystemPropertyFlagsProvider.getInt("defaultHttp2InitialStreamWindowSize");
    }

    @Override
    @Nullable
    public Float defaultHttp2StreamWindowUpdateRatio() {
        return SystemPropertyFlagsProvider.getFloat("defaultHttp2StreamWindowUpdateRatio");
    }

    @Override
    @Nullable
    public Integer defaultHttp2MaxFrameSize() {
        return SystemPropertyFlagsProvider.getInt("defaultHttp2MaxFrameSize");
    }

    @Override
    @Nullable
    public Long defaultHttp2MaxStreamsPerConnection() {
        return SystemPropertyFlagsProvider.getLong("defaultHttp2MaxStreamsPerConnection");
    }

    @Override
    @Nullable
    public Long defaultHttp2MaxHeaderListSize() {
        return SystemPropertyFlagsProvider.getLong("defaultHttp2MaxHeaderListSize");
    }

    @Override
    @Nullable
    public Integer defaultServerHttp2MaxResetFramesPerMinute() {
        return SystemPropertyFlagsProvider.getInt("defaultServerHttp2MaxResetFramesPerMinute");
    }

    @Override
    @Nullable
    public String defaultBackoffSpec() {
        return SystemPropertyFlagsProvider.getNormalized("defaultBackoffSpec");
    }

    @Override
    @Nullable
    public Integer defaultMaxTotalAttempts() {
        return SystemPropertyFlagsProvider.getInt("defaultMaxTotalAttempts");
    }

    @Override
    @Nullable
    public Long defaultRequestAutoAbortDelayMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultRequestAutoAbortDelayMillis");
    }

    @Override
    @Nullable
    public String routeCacheSpec() {
        return SystemPropertyFlagsProvider.getNormalized("routeCacheSpec");
    }

    @Override
    @Nullable
    public String routeDecoratorCacheSpec() {
        return SystemPropertyFlagsProvider.getNormalized("routeDecoratorCacheSpec");
    }

    @Override
    @Nullable
    public String parsedPathCacheSpec() {
        return SystemPropertyFlagsProvider.getNormalized("parsedPathCacheSpec");
    }

    @Override
    @Nullable
    public String headerValueCacheSpec() {
        return SystemPropertyFlagsProvider.getNormalized("headerValueCacheSpec");
    }

    @Override
    @Nullable
    public List<String> cachedHeaders() {
        String val = SystemPropertyFlagsProvider.getNormalized("cachedHeaders");
        if (val == null) {
            return null;
        }
        return CSV_SPLITTER.splitToList(val);
    }

    @Override
    @Nullable
    public String fileServiceCacheSpec() {
        return SystemPropertyFlagsProvider.getNormalized("fileServiceCacheSpec");
    }

    @Override
    @Nullable
    public String dnsCacheSpec() {
        return SystemPropertyFlagsProvider.getNormalized("dnsCacheSpec");
    }

    @Override
    @Nullable
    public Predicate<InetAddress> preferredIpV4Addresses() {
        String val = SystemPropertyFlagsProvider.getNormalized("preferredIpV4Addresses");
        if (val == null) {
            return null;
        }
        List preferredIpV4Addresses = CSV_SPLITTER.splitToList(val).stream().map(cidr -> {
            try {
                return InetAddressPredicates.ofCidr(cidr);
            }
            catch (Exception e) {
                logger.warn("Failed to parse a preferred IPv4: {}", cidr);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        switch (preferredIpV4Addresses.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Predicate)preferredIpV4Addresses.get(0);
            }
        }
        return inetAddress -> {
            for (Predicate preferredIpV4Addr : preferredIpV4Addresses) {
                if (!preferredIpV4Addr.test(inetAddress)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    @Nullable
    public Boolean useJdkDnsResolver() {
        return SystemPropertyFlagsProvider.getBoolean("useJdkDnsResolver");
    }

    @Override
    @Nullable
    public Boolean reportBlockedEventLoop() {
        return SystemPropertyFlagsProvider.getBoolean("reportBlockedEventLoop");
    }

    @Override
    @Nullable
    public Boolean reportMaskedRoutes() {
        return SystemPropertyFlagsProvider.getBoolean("reportMaskedRoutes");
    }

    @Override
    @Nullable
    public Boolean validateHeaders() {
        return SystemPropertyFlagsProvider.getBoolean("validateHeaders");
    }

    @Override
    @Nullable
    public Boolean tlsAllowUnsafeCiphers() {
        return SystemPropertyFlagsProvider.getBoolean("tlsAllowUnsafeCiphers");
    }

    @Override
    @Nullable
    public Integer defaultMaxClientHelloLength() {
        return SystemPropertyFlagsProvider.getInt("defaultMaxClientHelloLength");
    }

    @Override
    @Nullable
    public Set<TransientServiceOption> transientServiceOptions() {
        String val = SystemPropertyFlagsProvider.getNormalized("transientServiceOptions");
        if (val == null) {
            return null;
        }
        return Sets.immutableEnumSet(Streams.stream(CSV_SPLITTER.split(val)).map(feature -> TransientServiceOption.valueOf(Ascii.toUpperCase(feature))).collect(ImmutableSet.toImmutableSet()));
    }

    @Override
    @Nullable
    public Boolean useDefaultSocketOptions() {
        return SystemPropertyFlagsProvider.getBoolean("useDefaultSocketOptions");
    }

    @Override
    @Nullable
    public Boolean useLegacyRouteDecoratorOrdering() {
        return SystemPropertyFlagsProvider.getBoolean("useLegacyRouteDecoratorOrdering");
    }

    @Override
    @Nullable
    public Boolean allowDoubleDotsInQueryString() {
        return SystemPropertyFlagsProvider.getBoolean("allowDoubleDotsInQueryString");
    }

    @Override
    @Nullable
    public Boolean allowSemicolonInPathComponent() {
        return SystemPropertyFlagsProvider.getBoolean("allowSemicolonInPathComponent");
    }

    @Override
    @Nullable
    public Path defaultMultipartUploadsLocation() {
        return SystemPropertyFlagsProvider.getAndParse("defaultMultipartUploadsLocation", x$0 -> Paths.get(x$0, new String[0]));
    }

    @Override
    @Nullable
    public MultipartRemovalStrategy defaultMultipartRemovalStrategy() {
        String multipartRemovalStrategy = SystemPropertyFlagsProvider.getNormalized("defaultMultipartRemovalStrategy");
        if (multipartRemovalStrategy == null) {
            return null;
        }
        switch (multipartRemovalStrategy) {
            case "never": {
                return MultipartRemovalStrategy.NEVER;
            }
            case "on_response_completion": {
                return MultipartRemovalStrategy.ON_RESPONSE_COMPLETION;
            }
        }
        throw new IllegalArgumentException(multipartRemovalStrategy + " isn't a MultipartRemovalStrategy");
    }

    @Override
    @Nullable
    public Sampler<? super RequestContext> requestContextLeakDetectionSampler() {
        String spec = SystemPropertyFlagsProvider.getNormalized("requestContextLeakDetectionSampler");
        if (spec == null) {
            return null;
        }
        try {
            return Sampler.of(spec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid sampler spec: " + spec, e);
        }
    }

    @Override
    @Nullable
    public Long defaultUnhandledExceptionsReportIntervalMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultUnhandledExceptionsReportIntervalMillis");
    }

    @Override
    @Nullable
    public Long defaultHttp1ConnectionCloseDelayMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultHttp1ConnectionCloseDelayMillis");
    }

    @Override
    @Nullable
    public Long defaultUnloggedExceptionsReportIntervalMillis() {
        return SystemPropertyFlagsProvider.getLong("defaultUnloggedExceptionsReportIntervalMillis");
    }

    @Override
    @Nullable
    public ResponseTimeoutMode responseTimeoutMode() {
        return SystemPropertyFlagsProvider.getAndParse("responseTimeoutMode", ResponseTimeoutMode::valueOf);
    }

    @Override
    @Nullable
    public Boolean annotatedServiceContentLogging() {
        return SystemPropertyFlagsProvider.getBoolean("annotatedServiceContentLogging");
    }

    @Nullable
    private static Long getLong(String name) {
        return SystemPropertyFlagsProvider.getAndParse(name, Long::parseLong);
    }

    @Nullable
    private static Integer getInt(String name) {
        return SystemPropertyFlagsProvider.getAndParse(name, Integer::parseInt);
    }

    @Nullable
    private static Float getFloat(String name) {
        return SystemPropertyFlagsProvider.getAndParse(name, Float::parseFloat);
    }

    @Nullable
    private static Boolean getBoolean(String name) {
        return SystemPropertyFlagsProvider.getAndParse(name, SystemPropertyFlagsProvider::strictlyParseBoolean);
    }

    private static Boolean strictlyParseBoolean(String val) {
        if (!val.equals(Boolean.TRUE.toString()) && !val.equals(Boolean.FALSE.toString())) {
            throw new IllegalArgumentException(String.format("%s not in \"true\" or \"false\"", val));
        }
        return Boolean.valueOf(val);
    }

    @Nullable
    private static <T> T getAndParse(String name, Function<String, T> parser) {
        String val = SystemPropertyFlagsProvider.getNormalized(name);
        if (val == null) {
            return null;
        }
        return parser.apply(val);
    }

    @Nullable
    private static String getNormalized(String name) {
        String fullName = PREFIX + name;
        String value = System.getProperty(fullName);
        if (value != null) {
            value = Ascii.toLowerCase(value);
        }
        return value;
    }
}

