/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.CacheControl;
import io.opentelemetry.testing.internal.armeria.common.ContentDisposition;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.util.StringUtil;
import io.opentelemetry.testing.internal.io.netty.handler.codec.DateFormatter;
import io.opentelemetry.testing.internal.io.netty.handler.codec.ValueConverter;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

final class StringValueConverter
implements ValueConverter<String> {
    static final StringValueConverter INSTANCE = new StringValueConverter();

    private StringValueConverter() {
    }

    @Override
    @Nullable
    public String convertObject(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence || value instanceof Number || value instanceof MediaType) {
            return value.toString();
        }
        if (value instanceof Instant) {
            return DateFormatter.format(new Date(((Instant)value).toEpochMilli()));
        }
        if (value instanceof TemporalAccessor) {
            return DateFormatter.format(new Date(Instant.from((TemporalAccessor)value).toEpochMilli()));
        }
        if (value instanceof CacheControl) {
            return ((CacheControl)value).asHeaderValue();
        }
        if (value instanceof ContentDisposition) {
            return ((ContentDisposition)value).asHeaderValue();
        }
        if (value instanceof Date) {
            return DateFormatter.format((Date)value);
        }
        if (value instanceof Calendar) {
            return DateFormatter.format(((Calendar)value).getTime());
        }
        return value.toString();
    }

    @Override
    public String convertInt(int value) {
        return StringUtil.toString(value);
    }

    @Override
    public String convertLong(long value) {
        return StringUtil.toString(value);
    }

    @Override
    public String convertDouble(double value) {
        return String.valueOf(value);
    }

    @Override
    public String convertChar(char value) {
        return String.valueOf(value);
    }

    @Override
    public String convertBoolean(boolean value) {
        return String.valueOf(value);
    }

    @Override
    public String convertFloat(float value) {
        return String.valueOf(value);
    }

    @Override
    public boolean convertToBoolean(String value) {
        return StringUtil.toBoolean(value);
    }

    @Override
    public String convertByte(byte value) {
        return StringUtil.toString(value & 0xFF);
    }

    @Override
    public byte convertToByte(String value) {
        if (!value.isEmpty()) {
            return (byte)value.charAt(0);
        }
        return Byte.parseByte(value);
    }

    @Override
    public char convertToChar(String value) {
        return value.charAt(0);
    }

    @Override
    public String convertShort(short value) {
        return StringUtil.toString(value);
    }

    @Override
    public short convertToShort(String value) {
        return Short.valueOf(value);
    }

    @Override
    public int convertToInt(String value) {
        return Integer.parseInt(value);
    }

    @Override
    public long convertToLong(String value) {
        return Long.parseLong(value);
    }

    @Override
    public String convertTimeMillis(long value) {
        return DateFormatter.format(new Date(value));
    }

    @Override
    public long convertToTimeMillis(String value) {
        Date date = null;
        try {
            date = DateFormatter.parseHttpDate(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (date == null) {
            throw new IllegalArgumentException("not a date: " + value);
        }
        return date.getTime();
    }

    @Override
    public float convertToFloat(String value) {
        return Float.valueOf(value).floatValue();
    }

    @Override
    public double convertToDouble(String value) {
        return Double.valueOf(value);
    }
}

