/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.SplitHttpMessage;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public interface SplitHttpResponse
extends SplitHttpMessage {
    public CompletableFuture<ResponseHeaders> headers();

    @Override
    @UnstableApi
    default public HttpResponse unsplit() {
        CompletionStage future = this.headers().handle((headers, cause) -> {
            if (cause != null) {
                return HttpResponse.ofFailure(cause);
            }
            CompletionStage trailersFuture = this.trailers().thenApply(trailers -> {
                if (trailers.isEmpty()) {
                    return null;
                }
                return trailers;
            });
            return HttpResponse.of(headers, (Publisher<? extends HttpData>)this.body(), (CompletableFuture<HttpHeaders>)trailersFuture);
        });
        return HttpResponse.of((CompletableFuture<? extends HttpResponse>)future);
    }
}

