/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.MediaTypeSet;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Ascii;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.Objects;
import java.util.Set;

@UnstableApi
public abstract class SerializationFormatProvider {
    protected abstract Set<Entry> entries();

    @UnstableApi
    protected static final class Entry
    implements Comparable<Entry> {
        final String uriText;
        final MediaType primaryMediaType;
        final MediaTypeSet mediaTypes;

        public Entry(String uriText, MediaType primaryMediaType, MediaType ... alternativeMediaTypes) {
            this.uriText = Ascii.toLowerCase(Objects.requireNonNull(uriText, "uriText"));
            this.primaryMediaType = Objects.requireNonNull(primaryMediaType, "primaryMediaType");
            Objects.requireNonNull(alternativeMediaTypes, "alternativeMediaTypes");
            this.mediaTypes = MediaTypeSet.of(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(primaryMediaType)).add(alternativeMediaTypes)).build());
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != Entry.class) {
                return false;
            }
            return this.uriText.equals(((Entry)obj).uriText);
        }

        @Override
        public int compareTo(Entry o) {
            return this.uriText.compareTo(o.uriText);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("uriText", this.uriText).add("mediaTypes", this.mediaTypes).toString();
        }

        public int hashCode() {
            return this.uriText.hashCode();
        }
    }
}

