/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.ReactorNonBlockingUtil;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.common.metric.MoreMeterBinders;
import io.opentelemetry.testing.internal.armeria.common.util.BlockingTaskExecutor;
import io.opentelemetry.testing.internal.armeria.common.util.EventLoopGroups;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonPools {
    private static final Logger logger = LoggerFactory.getLogger(CommonPools.class);
    private static final BlockingTaskExecutor BLOCKING_TASK_EXECUTOR = BlockingTaskExecutor.builder().threadNamePrefix("armeria-common-blocking-tasks").build();
    private static final EventLoopGroup WORKER_GROUP = EventLoopGroups.newEventLoopGroup(Flags.numCommonWorkers(), "armeria-common-worker", true);

    public static BlockingTaskExecutor blockingTaskExecutor() {
        return BLOCKING_TASK_EXECUTOR;
    }

    public static EventLoopGroup workerGroup() {
        return WORKER_GROUP;
    }

    private CommonPools() {
    }

    static {
        MoreMeterBinders.eventLoopMetrics(WORKER_GROUP, new MeterIdPrefix("armeria.netty.common")).bindTo(Flags.meterRegistry());
        try {
            Class<?> aClass = Class.forName("io.opentelemetry.testing.internal.reactor.core.scheduler.Schedulers", true, CommonPools.class.getClassLoader());
            Method ignored = aClass.getDeclaredMethod("registerNonBlockingThreadPredicate", Predicate.class);
            ReactorNonBlockingUtil.registerEventLoopAsNonBlocking();
        }
        catch (ClassNotFoundException aClass) {
        }
        catch (NoSuchMethodException e) {
            logger.warn("Failed to register the common worker group as non-blocking for Reactor. Please consider upgrading Reactor to 3.7.0 or newer.");
        }
    }
}

